/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.buildpack.platform.build;

import cn.taketoday.lang.Assert;
import java.util.Comparator;

class LifecycleVersion
implements Comparable<LifecycleVersion> {
    private static final Comparator<LifecycleVersion> COMPARATOR = Comparator.comparingInt(LifecycleVersion::getMajor).thenComparingInt(LifecycleVersion::getMinor).thenComparing(LifecycleVersion::getPatch);
    private final int major;
    private final int minor;
    private final int patch;

    LifecycleVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LifecycleVersion other = (LifecycleVersion)obj;
        boolean result = this.major == other.major;
        result = result && this.minor == other.minor;
        result = result && this.patch == other.patch;
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        return result;
    }

    public String toString() {
        return "v" + this.major + "." + this.minor + "." + this.patch;
    }

    boolean isEqualOrGreaterThan(LifecycleVersion other) {
        return this.compareTo(other) >= 0;
    }

    @Override
    public int compareTo(LifecycleVersion other) {
        return COMPARATOR.compare(this, other);
    }

    int getMajor() {
        return this.major;
    }

    int getMinor() {
        return this.minor;
    }

    int getPatch() {
        return this.patch;
    }

    static LifecycleVersion parse(String value) {
        String[] components;
        Assert.hasText((String)value, (String)"Value must not be empty");
        if (value.startsWith("v") || value.startsWith("V")) {
            value = value.substring(1);
        }
        Assert.isTrue(((components = value.split("\\.")).length <= 3 ? 1 : 0) != 0, (String)("Malformed version number '" + value + "'"));
        int[] versions = new int[3];
        for (int i = 0; i < components.length; ++i) {
            try {
                versions[i] = Integer.parseInt(components[i]);
                continue;
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Malformed version number '" + value + "'", ex);
            }
        }
        return new LifecycleVersion(versions[0], versions[1], versions[2]);
    }
}

