/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.buildpack.platform.build;

import cn.taketoday.buildpack.platform.build.BuildOwner;
import cn.taketoday.buildpack.platform.build.BuilderMetadata;
import cn.taketoday.buildpack.platform.build.Buildpacks;
import cn.taketoday.buildpack.platform.build.Creator;
import cn.taketoday.buildpack.platform.docker.type.Image;
import cn.taketoday.buildpack.platform.docker.type.ImageArchive;
import cn.taketoday.buildpack.platform.docker.type.ImageReference;
import cn.taketoday.buildpack.platform.docker.type.Layer;
import cn.taketoday.buildpack.platform.io.Content;
import cn.taketoday.buildpack.platform.io.Owner;
import java.io.IOException;
import java.util.Map;

class EphemeralBuilder {
    static final String BUILDER_FOR_LABEL_NAME = "cn.taketoday.framework.builderFor";
    private final BuildOwner buildOwner;
    private final BuilderMetadata builderMetadata;
    private final ImageArchive archive;
    private final Creator creator;

    EphemeralBuilder(BuildOwner buildOwner, Image builderImage, ImageReference targetImage, BuilderMetadata builderMetadata, Creator creator, Map<String, String> env, Buildpacks buildpacks) throws IOException {
        ImageReference name = ImageReference.random("pack.local/builder/").inTaggedForm();
        this.buildOwner = buildOwner;
        this.creator = creator;
        this.builderMetadata = builderMetadata.copy(this::updateMetadata);
        this.archive = ImageArchive.from(builderImage, update -> {
            update.withUpdatedConfig(this.builderMetadata::attachTo);
            update.withUpdatedConfig(config -> config.withLabel(BUILDER_FOR_LABEL_NAME, targetImage.toString()));
            update.withTag(name);
            if (env != null && !env.isEmpty()) {
                update.withNewLayer(this.getEnvLayer(env));
            }
            if (buildpacks != null) {
                buildpacks.apply(update::withNewLayer);
            }
        });
    }

    private void updateMetadata(BuilderMetadata.Update update) {
        update.withCreatedBy(this.creator.getName(), this.creator.getVersion());
    }

    private Layer getEnvLayer(Map<String, String> env) throws IOException {
        return Layer.of(layout -> {
            for (Map.Entry entry : env.entrySet()) {
                String name = "/platform/env/" + (String)entry.getKey();
                Content content = Content.of(entry.getValue() != null ? (String)entry.getValue() : "");
                layout.file(name, Owner.ROOT, content);
            }
        });
    }

    ImageReference getName() {
        return this.archive.getTag();
    }

    Owner getBuildOwner() {
        return this.buildOwner;
    }

    BuilderMetadata getBuilderMetadata() {
        return this.builderMetadata;
    }

    ImageArchive getArchive() {
        return this.archive;
    }

    public String toString() {
        return this.archive.getTag().toString();
    }
}

