/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.buildpack.platform.build;

import cn.taketoday.buildpack.platform.build.Buildpack;
import cn.taketoday.buildpack.platform.build.BuildpackCoordinates;
import cn.taketoday.buildpack.platform.build.BuildpackReference;
import cn.taketoday.buildpack.platform.build.BuildpackResolverContext;
import cn.taketoday.buildpack.platform.docker.type.Layer;
import cn.taketoday.buildpack.platform.io.Content;
import cn.taketoday.buildpack.platform.io.FilePermissions;
import cn.taketoday.buildpack.platform.io.IOConsumer;
import cn.taketoday.buildpack.platform.io.Layout;
import cn.taketoday.buildpack.platform.io.Owner;
import cn.taketoday.lang.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

final class DirectoryBuildpack
implements Buildpack {
    private final Path path;
    private final BuildpackCoordinates coordinates;

    private DirectoryBuildpack(Path path) {
        this.path = path;
        this.coordinates = this.findBuildpackCoordinates(path);
    }

    private BuildpackCoordinates findBuildpackCoordinates(Path path) {
        BuildpackCoordinates buildpackCoordinates;
        block8: {
            Path buildpackToml = path.resolve("buildpack.toml");
            Assert.isTrue((boolean)Files.exists(buildpackToml, new LinkOption[0]), () -> "Buildpack descriptor 'buildpack.toml' is required in buildpack '" + path + "'");
            InputStream inputStream = Files.newInputStream(buildpackToml, new OpenOption[0]);
            try {
                buildpackCoordinates = BuildpackCoordinates.fromToml(inputStream, path);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException("Error parsing descriptor for buildpack '" + path + "'", ex);
                }
            }
            inputStream.close();
        }
        return buildpackCoordinates;
    }

    @Override
    public BuildpackCoordinates getCoordinates() {
        return this.coordinates;
    }

    @Override
    public void apply(IOConsumer<Layer> layers) throws IOException {
        layers.accept(Layer.of(this::addLayerContent));
    }

    private void addLayerContent(Layout layout) throws IOException {
        String id = this.coordinates.getSanitizedId();
        Path cnbPath = Paths.get("/cnb/buildpacks/", id, this.coordinates.getVersion());
        this.writeBasePathEntries(layout, cnbPath);
        Files.walkFileTree(this.path, new LayoutFileVisitor(this.path, cnbPath, layout));
    }

    private void writeBasePathEntries(Layout layout, Path basePath) throws IOException {
        int pathCount = basePath.getNameCount();
        for (int pathIndex = 1; pathIndex < pathCount + 1; ++pathIndex) {
            String name = "/" + basePath.subpath(0, pathIndex) + "/";
            layout.directory(name, Owner.ROOT);
        }
    }

    static Buildpack resolve(BuildpackResolverContext context, BuildpackReference reference) {
        Path path = reference.asPath();
        if (path != null && Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
            return new DirectoryBuildpack(path);
        }
        return null;
    }

    private static class LayoutFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Path basePath;
        private final Path layerPath;
        private final Layout layout;

        LayoutFileVisitor(Path basePath, Path layerPath, Layout layout) {
            this.basePath = basePath;
            this.layerPath = layerPath;
            this.layout = layout;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (!dir.equals(this.basePath)) {
                this.layout.directory(this.relocate(dir), Owner.ROOT, this.getMode(dir));
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            this.layout.file(this.relocate(file), Owner.ROOT, this.getMode(file), Content.of(file.toFile()));
            return FileVisitResult.CONTINUE;
        }

        private int getMode(Path path) throws IOException {
            try {
                return FilePermissions.umaskForPath(path);
            }
            catch (IllegalStateException ex) {
                throw new IllegalStateException("Buildpack content in a directory is not supported on this operating system");
            }
        }

        private String relocate(Path path) {
            Path node = path.subpath(this.basePath.getNameCount(), path.getNameCount());
            return Paths.get(this.layerPath.toString(), node.toString()).toString();
        }
    }
}

