/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.buildpack.platform.build;

import cn.taketoday.buildpack.platform.build.Buildpack;
import cn.taketoday.buildpack.platform.build.BuildpackCoordinates;
import cn.taketoday.buildpack.platform.docker.type.Layer;
import cn.taketoday.buildpack.platform.io.Content;
import cn.taketoday.buildpack.platform.io.IOConsumer;
import cn.taketoday.buildpack.platform.io.Layout;
import cn.taketoday.buildpack.platform.io.Owner;
import cn.taketoday.util.CollectionUtils;
import cn.taketoday.util.StringUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

final class Buildpacks {
    static final Buildpacks EMPTY = new Buildpacks(Collections.emptyList());
    private final List<Buildpack> buildpacks;

    private Buildpacks(List<Buildpack> buildpacks) {
        this.buildpacks = buildpacks;
    }

    List<Buildpack> getBuildpacks() {
        return this.buildpacks;
    }

    void apply(IOConsumer<Layer> layers) throws IOException {
        if (!this.buildpacks.isEmpty()) {
            for (Buildpack buildpack : this.buildpacks) {
                buildpack.apply(layers);
            }
            layers.accept(Layer.of(this::addOrderLayerContent));
        }
    }

    void addOrderLayerContent(Layout layout) throws IOException {
        layout.file("/cnb/order.toml", Owner.ROOT, Content.of(this.getOrderToml()));
    }

    private String getOrderToml() {
        StringBuilder builder = new StringBuilder();
        builder.append("[[order]]\n\n");
        for (Buildpack buildpack : this.buildpacks) {
            this.appendToOrderToml(builder, buildpack.getCoordinates());
        }
        return builder.toString();
    }

    private void appendToOrderToml(StringBuilder builder, BuildpackCoordinates coordinates) {
        builder.append("  [[order.group]]\n");
        builder.append("    id = \"").append(coordinates.getId()).append("\"\n");
        if (StringUtils.hasText((String)coordinates.getVersion())) {
            builder.append("    version = \"").append(coordinates.getVersion()).append("\"\n");
        }
        builder.append("\n");
    }

    static Buildpacks of(List<Buildpack> buildpacks) {
        return CollectionUtils.isEmpty(buildpacks) ? EMPTY : new Buildpacks(buildpacks);
    }
}

