/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.buildpack.platform.build;

import cn.taketoday.buildpack.platform.build.BuilderBuildpack;
import cn.taketoday.buildpack.platform.build.Buildpack;
import cn.taketoday.buildpack.platform.build.BuildpackReference;
import cn.taketoday.buildpack.platform.build.BuildpackResolver;
import cn.taketoday.buildpack.platform.build.BuildpackResolverContext;
import cn.taketoday.buildpack.platform.build.Buildpacks;
import cn.taketoday.buildpack.platform.build.DirectoryBuildpack;
import cn.taketoday.buildpack.platform.build.ImageBuildpack;
import cn.taketoday.buildpack.platform.build.TarGzipBuildpack;
import cn.taketoday.lang.Assert;
import cn.taketoday.util.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

final class BuildpackResolvers {
    private static final List<BuildpackResolver> resolvers = BuildpackResolvers.getResolvers();

    private BuildpackResolvers() {
    }

    private static List<BuildpackResolver> getResolvers() {
        return List.of(BuilderBuildpack::resolve, DirectoryBuildpack::resolve, TarGzipBuildpack::resolve, ImageBuildpack::resolve);
    }

    static Buildpacks resolveAll(BuildpackResolverContext context, Collection<BuildpackReference> references) {
        Assert.notNull((Object)context, (String)"Context is required");
        if (CollectionUtils.isEmpty(references)) {
            return Buildpacks.EMPTY;
        }
        ArrayList<Buildpack> buildpacks = new ArrayList<Buildpack>(references.size());
        for (BuildpackReference reference : references) {
            buildpacks.add(BuildpackResolvers.resolve(context, reference));
        }
        return Buildpacks.of(buildpacks);
    }

    private static Buildpack resolve(BuildpackResolverContext context, BuildpackReference reference) {
        Assert.notNull((Object)reference, (String)"Reference is required");
        for (BuildpackResolver resolver : resolvers) {
            Buildpack buildpack = resolver.resolve(context, reference);
            if (buildpack == null) continue;
            return buildpack;
        }
        throw new IllegalArgumentException("Invalid buildpack reference '" + reference + "'");
    }
}

