/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.buildpack.platform.build;

import cn.taketoday.lang.Assert;
import cn.taketoday.lang.Nullable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class BuildpackReference {
    private final String value;

    private BuildpackReference(String value) {
        this.value = value;
    }

    boolean hasPrefix(String prefix) {
        return this.value.startsWith(prefix);
    }

    @Nullable
    String getSubReference(String prefix) {
        return this.value.startsWith(prefix) ? this.value.substring(prefix.length()) : null;
    }

    Path asPath() {
        try {
            URL url = new URL(this.value);
            if (url.getProtocol().equals("file")) {
                return Paths.get(url.getPath(), new String[0]);
            }
            return null;
        }
        catch (MalformedURLException url) {
            try {
                return Paths.get(this.value, new String[0]);
            }
            catch (Exception ex) {
                return null;
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.value.equals(((BuildpackReference)obj).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value;
    }

    public static BuildpackReference of(String value) {
        Assert.hasText((String)value, (String)"Value must not be empty");
        return new BuildpackReference(value);
    }
}

