/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.buildpack.platform.build;

import cn.taketoday.buildpack.platform.docker.type.Image;
import cn.taketoday.buildpack.platform.docker.type.ImageConfig;
import cn.taketoday.buildpack.platform.json.MappedObject;
import cn.taketoday.buildpack.platform.json.SharedObjectMapper;
import cn.taketoday.lang.Assert;
import cn.taketoday.util.StringUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.lang.invoke.MethodHandles;

final class BuildpackMetadata
extends MappedObject {
    private static final String LABEL_NAME = "io.buildpacks.buildpackage.metadata";
    private final String id = this.valueAt("/id", String.class);
    private final String version = this.valueAt("/version", String.class);
    private final String homepage = this.valueAt("/homepage", String.class);

    private BuildpackMetadata(JsonNode node) {
        super(node, MethodHandles.lookup());
    }

    String getId() {
        return this.id;
    }

    String getVersion() {
        return this.version;
    }

    String getHomepage() {
        return this.homepage;
    }

    static BuildpackMetadata fromImage(Image image) throws IOException {
        Assert.notNull((Object)image, (String)"Image is required");
        return BuildpackMetadata.fromImageConfig(image.getConfig());
    }

    static BuildpackMetadata fromImageConfig(ImageConfig imageConfig) throws IOException {
        Assert.notNull((Object)imageConfig, (String)"ImageConfig is required");
        String json = imageConfig.getLabels().get(LABEL_NAME);
        Assert.notNull((Object)json, () -> "No 'io.buildpacks.buildpackage.metadata' label found in image config labels '" + StringUtils.collectionToCommaDelimitedString(imageConfig.getLabels().keySet()) + "'");
        return BuildpackMetadata.fromJson(json);
    }

    static BuildpackMetadata fromJson(String json) throws IOException {
        return BuildpackMetadata.fromJson(SharedObjectMapper.get().readTree(json));
    }

    static BuildpackMetadata fromJson(JsonNode node) {
        return new BuildpackMetadata(node);
    }
}

