/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.buildpack.platform.build;

import cn.taketoday.buildpack.platform.build.BuildpackMetadata;
import cn.taketoday.buildpack.platform.docker.type.Image;
import cn.taketoday.buildpack.platform.docker.type.ImageConfig;
import cn.taketoday.buildpack.platform.json.MappedObject;
import cn.taketoday.buildpack.platform.json.SharedObjectMapper;
import cn.taketoday.lang.Assert;
import cn.taketoday.util.StringUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

class BuilderMetadata
extends MappedObject {
    private static final String LABEL_NAME = "io.buildpacks.builder.metadata";
    private static final String[] EMPTY_MIRRORS = new String[0];
    private final Stack stack = this.valueAt("/stack", Stack.class);
    private final Lifecycle lifecycle = this.valueAt("/lifecycle", Lifecycle.class);
    private final CreatedBy createdBy = this.valueAt("/createdBy", CreatedBy.class);
    private final List<BuildpackMetadata> buildpacks = this.extractBuildpacks(this.getNode().at("/buildpacks"));

    BuilderMetadata(JsonNode node) {
        super(node, MethodHandles.lookup());
    }

    private List<BuildpackMetadata> extractBuildpacks(JsonNode node) {
        if (node.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BuildpackMetadata> entries = new ArrayList<BuildpackMetadata>();
        node.forEach(child -> entries.add(BuildpackMetadata.fromJson(child)));
        return entries;
    }

    Stack getStack() {
        return this.stack;
    }

    Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    CreatedBy getCreatedBy() {
        return this.createdBy;
    }

    List<BuildpackMetadata> getBuildpacks() {
        return this.buildpacks;
    }

    BuilderMetadata copy(Consumer<Update> update) {
        return new Update(this).run(update);
    }

    void attachTo(ImageConfig.Update update) {
        try {
            String json = SharedObjectMapper.get().writeValueAsString((Object)this.getNode());
            update.withLabel(LABEL_NAME, json);
        }
        catch (JsonProcessingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    static BuilderMetadata fromImage(Image image) throws IOException {
        Assert.notNull((Object)image, (String)"Image is required");
        return BuilderMetadata.fromImageConfig(image.getConfig());
    }

    static BuilderMetadata fromImageConfig(ImageConfig imageConfig) throws IOException {
        Assert.notNull((Object)imageConfig, (String)"ImageConfig is required");
        String json = imageConfig.getLabels().get(LABEL_NAME);
        Assert.notNull((Object)json, () -> "No 'io.buildpacks.builder.metadata' label found in image config labels '" + StringUtils.collectionToCommaDelimitedString(imageConfig.getLabels().keySet()) + "'");
        return BuilderMetadata.fromJson(json);
    }

    static BuilderMetadata fromJson(String json) throws IOException {
        return new BuilderMetadata(SharedObjectMapper.get().readTree(json));
    }

    static interface Stack {
        public RunImage getRunImage();

        public static interface RunImage {
            public String getImage();

            default public String[] getMirrors() {
                return EMPTY_MIRRORS;
            }
        }
    }

    static interface Lifecycle {
        public String getVersion();

        public Api getApi();

        public Apis getApis();

        public static interface Apis {
            default public String[] getBuildpack() {
                return (String[])BuilderMetadata.valueAt(this, "/buildpack/supported", String[].class);
            }

            default public String[] getPlatform() {
                return (String[])BuilderMetadata.valueAt(this, "/platform/supported", String[].class);
            }
        }

        public static interface Api {
            public String getBuildpack();

            public String getPlatform();
        }
    }

    static interface CreatedBy {
        public String getName();

        public String getVersion();
    }

    static final class Update {
        private final ObjectNode copy;

        private Update(BuilderMetadata source) {
            this.copy = (ObjectNode)source.getNode().deepCopy();
        }

        private BuilderMetadata run(Consumer<Update> update) {
            update.accept(this);
            return new BuilderMetadata((JsonNode)this.copy);
        }

        void withCreatedBy(String name, String version) {
            ObjectNode createdBy = (ObjectNode)this.copy.at("/createdBy");
            if (createdBy == null) {
                createdBy = this.copy.putObject("createdBy");
            }
            createdBy.put("name", name);
            createdBy.put("version", version);
        }
    }
}

