/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.buildpack.platform.build;

public class BuilderException
extends RuntimeException {
    private final String operation;
    private final int statusCode;

    BuilderException(String operation, int statusCode) {
        super(BuilderException.buildMessage(operation, statusCode));
        this.operation = operation;
        this.statusCode = statusCode;
    }

    public String getOperation() {
        return this.operation;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    private static String buildMessage(String operation, int statusCode) {
        StringBuilder message = new StringBuilder("Builder");
        if (operation != null && !operation.isEmpty()) {
            message.append(" lifecycle '").append(operation).append("'");
        }
        message.append(" failed with status code ").append(statusCode);
        return message.toString();
    }
}

