/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.buildpack.platform.build;

import cn.taketoday.buildpack.platform.build.BuildLog;
import cn.taketoday.buildpack.platform.build.BuildOwner;
import cn.taketoday.buildpack.platform.build.BuildRequest;
import cn.taketoday.buildpack.platform.build.BuilderMetadata;
import cn.taketoday.buildpack.platform.build.BuildpackLayersMetadata;
import cn.taketoday.buildpack.platform.build.BuildpackMetadata;
import cn.taketoday.buildpack.platform.build.BuildpackResolverContext;
import cn.taketoday.buildpack.platform.build.BuildpackResolvers;
import cn.taketoday.buildpack.platform.build.Buildpacks;
import cn.taketoday.buildpack.platform.build.EphemeralBuilder;
import cn.taketoday.buildpack.platform.build.ImageType;
import cn.taketoday.buildpack.platform.build.Lifecycle;
import cn.taketoday.buildpack.platform.build.PullPolicy;
import cn.taketoday.buildpack.platform.build.StackId;
import cn.taketoday.buildpack.platform.docker.DockerApi;
import cn.taketoday.buildpack.platform.docker.TotalProgressEvent;
import cn.taketoday.buildpack.platform.docker.TotalProgressPullListener;
import cn.taketoday.buildpack.platform.docker.TotalProgressPushListener;
import cn.taketoday.buildpack.platform.docker.UpdateListener;
import cn.taketoday.buildpack.platform.docker.configuration.DockerConfiguration;
import cn.taketoday.buildpack.platform.docker.configuration.ResolvedDockerHost;
import cn.taketoday.buildpack.platform.docker.transport.DockerEngineException;
import cn.taketoday.buildpack.platform.docker.type.Image;
import cn.taketoday.buildpack.platform.docker.type.ImageReference;
import cn.taketoday.buildpack.platform.io.IOBiConsumer;
import cn.taketoday.lang.Assert;
import cn.taketoday.util.StringUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;

public class Builder {
    private final BuildLog log;
    private final DockerApi docker;
    private final DockerConfiguration dockerConfiguration;

    public Builder() {
        this(BuildLog.toSystemOut());
    }

    public Builder(DockerConfiguration dockerConfiguration) {
        this(BuildLog.toSystemOut(), dockerConfiguration);
    }

    public Builder(BuildLog log) {
        this(log, new DockerApi(), null);
    }

    public Builder(BuildLog log, DockerConfiguration dockerConfiguration) {
        this(log, new DockerApi(dockerConfiguration != null ? dockerConfiguration.getHost() : null), dockerConfiguration);
    }

    Builder(BuildLog log, DockerApi docker, DockerConfiguration dockerConfiguration) {
        Assert.notNull((Object)log, (String)"Log is required");
        this.log = log;
        this.docker = docker;
        this.dockerConfiguration = dockerConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(BuildRequest request) throws DockerEngineException, IOException {
        Assert.notNull((Object)request, (String)"Request is required");
        this.log.start(request);
        String domain = request.getBuilder().getDomain();
        PullPolicy pullPolicy = request.getPullPolicy();
        ImageFetcher imageFetcher = new ImageFetcher(domain, this.getBuilderAuthHeader(), pullPolicy);
        Image builderImage = imageFetcher.fetchImage(ImageType.BUILDER, request.getBuilder());
        BuilderMetadata builderMetadata = BuilderMetadata.fromImage(builderImage);
        request = this.withRunImageIfNeeded(request, builderMetadata.getStack());
        Image runImage = imageFetcher.fetchImage(ImageType.RUNNER, request.getRunImage());
        this.assertStackIdsMatch(runImage, builderImage);
        BuildOwner buildOwner = BuildOwner.fromEnv(builderImage.getConfig().getEnv());
        BuildpackLayersMetadata buildpackLayersMetadata = BuildpackLayersMetadata.fromImage(builderImage);
        Buildpacks buildpacks = this.getBuildpacks(request, imageFetcher, builderMetadata, buildpackLayersMetadata);
        EphemeralBuilder ephemeralBuilder = new EphemeralBuilder(buildOwner, builderImage, request.getName(), builderMetadata, request.getCreator(), request.getEnv(), buildpacks);
        this.docker.image().load(ephemeralBuilder.getArchive(), UpdateListener.none());
        try {
            this.executeLifecycle(request, ephemeralBuilder);
            this.tagImage(request.getName(), request.getTags());
            if (request.isPublish()) {
                this.pushImages(request.getName(), request.getTags());
            }
        }
        finally {
            this.docker.image().remove(ephemeralBuilder.getName(), true);
        }
    }

    private BuildRequest withRunImageIfNeeded(BuildRequest request, BuilderMetadata.Stack builderStack) {
        if (request.getRunImage() != null) {
            return request;
        }
        return request.withRunImage(this.getRunImageReferenceForStack(builderStack));
    }

    private ImageReference getRunImageReferenceForStack(BuilderMetadata.Stack stack) {
        String name = stack.getRunImage().getImage();
        Assert.state((boolean)StringUtils.hasText((String)name), (String)"Run image must be specified in the builder image stack");
        return ImageReference.of(name).inTaggedOrDigestForm();
    }

    private void assertStackIdsMatch(Image runImage, Image builderImage) {
        StackId runImageStackId = StackId.fromImage(runImage);
        StackId builderImageStackId = StackId.fromImage(builderImage);
        Assert.state((boolean)runImageStackId.equals(builderImageStackId), () -> "Run image stack '" + runImageStackId + "' does not match builder stack '" + builderImageStackId + "'");
    }

    private Buildpacks getBuildpacks(BuildRequest request, ImageFetcher imageFetcher, BuilderMetadata builderMetadata, BuildpackLayersMetadata buildpackLayersMetadata) {
        BuilderResolverContext resolverContext = new BuilderResolverContext(imageFetcher, builderMetadata, buildpackLayersMetadata);
        return BuildpackResolvers.resolveAll(resolverContext, request.getBuildpacks());
    }

    private void executeLifecycle(BuildRequest request, EphemeralBuilder builder) throws IOException {
        ResolvedDockerHost dockerHost = null;
        if (this.dockerConfiguration != null && this.dockerConfiguration.isBindHostToBuilder()) {
            dockerHost = ResolvedDockerHost.from(this.dockerConfiguration.getHost());
        }
        try (Lifecycle lifecycle = new Lifecycle(this.log, this.docker, dockerHost, request, builder);){
            lifecycle.execute();
        }
    }

    private void tagImage(ImageReference sourceReference, List<ImageReference> tags) throws IOException {
        for (ImageReference tag : tags) {
            this.docker.image().tag(sourceReference, tag);
            this.log.taggedImage(tag);
        }
    }

    private void pushImages(ImageReference name, List<ImageReference> tags) throws IOException {
        this.pushImage(name);
        for (ImageReference tag : tags) {
            this.pushImage(tag);
        }
    }

    private void pushImage(ImageReference reference) throws IOException {
        Consumer<TotalProgressEvent> progressConsumer = this.log.pushingImage(reference);
        TotalProgressPushListener listener = new TotalProgressPushListener(progressConsumer);
        this.docker.image().push(reference, listener, this.getPublishAuthHeader());
        this.log.pushedImage(reference);
    }

    private String getBuilderAuthHeader() {
        return this.dockerConfiguration != null && this.dockerConfiguration.getBuilderRegistryAuthentication() != null ? this.dockerConfiguration.getBuilderRegistryAuthentication().getAuthHeader() : null;
    }

    private String getPublishAuthHeader() {
        return this.dockerConfiguration != null && this.dockerConfiguration.getPublishRegistryAuthentication() != null ? this.dockerConfiguration.getPublishRegistryAuthentication().getAuthHeader() : null;
    }

    private class ImageFetcher {
        private final String domain;
        private final String authHeader;
        private final PullPolicy pullPolicy;

        ImageFetcher(String domain, String authHeader, PullPolicy pullPolicy) {
            this.domain = domain;
            this.authHeader = authHeader;
            this.pullPolicy = pullPolicy;
        }

        Image fetchImage(ImageType type, ImageReference reference) throws IOException {
            Assert.notNull((Object)((Object)type), (String)"Type is required");
            Assert.notNull((Object)reference, (String)"Reference is required");
            Assert.state((this.authHeader == null || reference.getDomain().equals(this.domain) ? 1 : 0) != 0, () -> String.format("%s '%s' must be pulled from the '%s' authenticated registry", StringUtils.capitalize((String)type.getDescription()), reference, this.domain));
            if (this.pullPolicy == PullPolicy.ALWAYS) {
                return this.pullImage(reference, type);
            }
            try {
                return Builder.this.docker.image().inspect(reference);
            }
            catch (DockerEngineException ex) {
                if (this.pullPolicy == PullPolicy.IF_NOT_PRESENT && ex.getStatusCode() == 404) {
                    return this.pullImage(reference, type);
                }
                throw ex;
            }
        }

        private Image pullImage(ImageReference reference, ImageType imageType) throws IOException {
            TotalProgressPullListener listener = new TotalProgressPullListener(Builder.this.log.pullingImage(reference, imageType));
            Image image = Builder.this.docker.image().pull(reference, listener, this.authHeader);
            Builder.this.log.pulledImage(image, imageType);
            return image;
        }
    }

    private class BuilderResolverContext
    implements BuildpackResolverContext {
        private final ImageFetcher imageFetcher;
        private final BuilderMetadata builderMetadata;
        private final BuildpackLayersMetadata buildpackLayersMetadata;

        BuilderResolverContext(ImageFetcher imageFetcher, BuilderMetadata builderMetadata, BuildpackLayersMetadata buildpackLayersMetadata) {
            this.imageFetcher = imageFetcher;
            this.builderMetadata = builderMetadata;
            this.buildpackLayersMetadata = buildpackLayersMetadata;
        }

        @Override
        public List<BuildpackMetadata> getBuildpackMetadata() {
            return this.builderMetadata.getBuildpacks();
        }

        @Override
        public BuildpackLayersMetadata getBuildpackLayersMetadata() {
            return this.buildpackLayersMetadata;
        }

        @Override
        public Image fetchImage(ImageReference reference, ImageType imageType) throws IOException {
            return this.imageFetcher.fetchImage(imageType, reference);
        }

        @Override
        public void exportImageLayers(ImageReference reference, IOBiConsumer<String, Path> exports) throws IOException {
            Builder.this.docker.image().exportLayerFiles(reference, exports);
        }
    }
}

