/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.buildpack.platform.build;

import cn.taketoday.buildpack.platform.build.BuildRequest;
import cn.taketoday.buildpack.platform.build.Cache;
import cn.taketoday.buildpack.platform.build.ImageType;
import cn.taketoday.buildpack.platform.build.LifecycleVersion;
import cn.taketoday.buildpack.platform.build.PrintStreamBuildLog;
import cn.taketoday.buildpack.platform.docker.LogUpdateEvent;
import cn.taketoday.buildpack.platform.docker.TotalProgressEvent;
import cn.taketoday.buildpack.platform.docker.type.Image;
import cn.taketoday.buildpack.platform.docker.type.ImageReference;
import cn.taketoday.buildpack.platform.docker.type.VolumeName;
import java.io.PrintStream;
import java.util.function.Consumer;

public interface BuildLog {
    public void start(BuildRequest var1);

    public Consumer<TotalProgressEvent> pullingImage(ImageReference var1, ImageType var2);

    public void pulledImage(Image var1, ImageType var2);

    public Consumer<TotalProgressEvent> pushingImage(ImageReference var1);

    public void pushedImage(ImageReference var1);

    public void executingLifecycle(BuildRequest var1, LifecycleVersion var2, VolumeName var3);

    public void executingLifecycle(BuildRequest var1, LifecycleVersion var2, Cache var3);

    public Consumer<LogUpdateEvent> runningPhase(BuildRequest var1, String var2);

    public void skippingPhase(String var1, String var2);

    public void executedLifecycle(BuildRequest var1);

    public void taggedImage(ImageReference var1);

    public static BuildLog toSystemOut() {
        return BuildLog.to(System.out);
    }

    public static BuildLog to(PrintStream out) {
        return new PrintStreamBuildLog(out);
    }
}

