/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.buildpack.platform.build;

import cn.taketoday.buildpack.platform.build.BuildLog;
import cn.taketoday.buildpack.platform.build.BuildRequest;
import cn.taketoday.buildpack.platform.build.Cache;
import cn.taketoday.buildpack.platform.build.ImageType;
import cn.taketoday.buildpack.platform.build.LifecycleVersion;
import cn.taketoday.buildpack.platform.docker.LogUpdateEvent;
import cn.taketoday.buildpack.platform.docker.TotalProgressEvent;
import cn.taketoday.buildpack.platform.docker.type.Image;
import cn.taketoday.buildpack.platform.docker.type.ImageReference;
import cn.taketoday.buildpack.platform.docker.type.VolumeName;
import java.util.List;
import java.util.function.Consumer;

public abstract class AbstractBuildLog
implements BuildLog {
    @Override
    public void start(BuildRequest request) {
        this.log("Building image '" + request.getName() + "'");
        this.log();
    }

    @Override
    public Consumer<TotalProgressEvent> pullingImage(ImageReference imageReference, ImageType imageType) {
        return this.getProgressConsumer(String.format(" > Pulling %s '%s'", imageType.getDescription(), imageReference));
    }

    @Override
    public void pulledImage(Image image, ImageType imageType) {
        this.log(String.format(" > Pulled %s '%s'", imageType.getDescription(), this.getDigest(image)));
    }

    @Override
    public Consumer<TotalProgressEvent> pushingImage(ImageReference imageReference) {
        return this.getProgressConsumer(String.format(" > Pushing image '%s'", imageReference));
    }

    @Override
    public void pushedImage(ImageReference imageReference) {
        this.log(String.format(" > Pushed image '%s'", imageReference));
    }

    @Override
    public void executingLifecycle(BuildRequest request, LifecycleVersion version, VolumeName buildCacheVolume) {
        this.log(" > Executing lifecycle version " + version);
        this.log(" > Using build cache volume '" + buildCacheVolume + "'");
    }

    @Override
    public void executingLifecycle(BuildRequest request, LifecycleVersion version, Cache buildCache) {
        this.log(" > Executing lifecycle version " + version);
        this.log(" > Using build cache " + buildCache);
    }

    @Override
    public Consumer<LogUpdateEvent> runningPhase(BuildRequest request, String name) {
        this.log();
        this.log(" > Running " + name);
        String prefix = String.format("    %-14s", "[" + name + "] ");
        return event -> this.log(prefix + event);
    }

    @Override
    public void skippingPhase(String name, String reason) {
        this.log();
        this.log(" > Skipping " + name + " " + reason);
        this.log();
    }

    @Override
    public void executedLifecycle(BuildRequest request) {
        this.log();
        this.log("Successfully built image '" + request.getName() + "'");
        this.log();
    }

    @Override
    public void taggedImage(ImageReference tag) {
        this.log("Successfully created image tag '" + tag + "'");
        this.log();
    }

    private String getDigest(Image image) {
        List<String> digests = image.getDigests();
        return digests.isEmpty() ? "" : digests.get(0);
    }

    protected void log() {
        this.log("");
    }

    protected abstract void log(String var1);

    protected abstract Consumer<TotalProgressEvent> getProgressConsumer(String var1);
}

