/*
 * Decompiled with CFR 0.152.
 */
package infra.app.loader.jar;

import infra.app.loader.jar.JarEntriesStream;
import infra.app.loader.zip.ZipContent;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.CodeSigner;
import java.security.cert.Certificate;
import java.util.jar.JarEntry;
import org.jspecify.annotations.Nullable;

final class SecurityInfo {
    static final SecurityInfo NONE = new SecurityInfo(null, null);
    private final Certificate @Nullable [][] certificateLookups;
    private final CodeSigner @Nullable [][] codeSignerLookups;

    private SecurityInfo(Certificate @Nullable [][] entryCertificates, CodeSigner @Nullable [][] entryCodeSigners) {
        this.certificateLookups = entryCertificates;
        this.codeSignerLookups = entryCodeSigners;
    }

    Certificate @Nullable [] getCertificates(ZipContent.Entry contentEntry) {
        return this.certificateLookups != null ? this.clone(this.certificateLookups[contentEntry.getLookupIndex()]) : null;
    }

    CodeSigner @Nullable [] getCodeSigners(ZipContent.Entry contentEntry) {
        return this.codeSignerLookups != null ? this.clone(this.codeSignerLookups[contentEntry.getLookupIndex()]) : null;
    }

    private <T> T @Nullable [] clone(T @Nullable [] array) {
        return array != null ? (Object[])array.clone() : null;
    }

    static SecurityInfo get(ZipContent content) {
        if (!content.hasJarSignatureFile()) {
            return NONE;
        }
        try {
            return SecurityInfo.load(content);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private static SecurityInfo load(ZipContent content) throws IOException {
        int size = content.size();
        boolean hasSecurityInfo = false;
        Certificate[][] entryCertificates = new Certificate[size][];
        CodeSigner[][] entryCodeSigners = new CodeSigner[size][];
        try (JarEntriesStream entries = new JarEntriesStream(content.openRawZipData().asInputStream());){
            JarEntry entry = entries.getNextEntry();
            while (entry != null) {
                ZipContent.Entry relatedEntry = content.getEntry(entry.getName());
                if (relatedEntry != null && entries.matches(relatedEntry.isDirectory(), relatedEntry.getUncompressedSize(), relatedEntry.getCompressionMethod(), () -> relatedEntry.openContent().asInputStream())) {
                    Certificate[] certificates = entry.getCertificates();
                    CodeSigner[] codeSigners = entry.getCodeSigners();
                    if (certificates != null || codeSigners != null) {
                        hasSecurityInfo = true;
                        entryCertificates[relatedEntry.getLookupIndex()] = certificates;
                        entryCodeSigners[relatedEntry.getLookupIndex()] = codeSigners;
                    }
                }
                entry = entries.getNextEntry();
            }
        }
        return !hasSecurityInfo ? NONE : new SecurityInfo(entryCertificates, entryCodeSigners);
    }
}

