/*
 * Decompiled with CFR 0.152.
 */
package infra.app.loader;

import infra.app.loader.jarmode.JarMode;
import infra.lang.TodayStrategies;
import infra.util.ClassUtils;
import infra.util.ExceptionUtils;
import java.lang.reflect.Constructor;
import java.util.List;
import org.jspecify.annotations.Nullable;

final class JarModeRunner {
    static final String DISABLE_SYSTEM_EXIT = JarModeRunner.class.getName() + ".DISABLE_SYSTEM_EXIT";

    private JarModeRunner() {
    }

    static void main(String[] args) {
        String mode = System.getProperty("jarmode");
        List candidates = TodayStrategies.find(JarMode.class, (ClassLoader)ClassUtils.getDefaultClassLoader());
        for (JarMode candidate : candidates) {
            if (!JarModeRunner.tryRun(candidate, mode, args)) continue;
            return;
        }
        JarMode jarMode = JarModeRunner.findDefault();
        if (jarMode != null && JarModeRunner.tryRun(jarMode, mode, args)) {
            return;
        }
        System.err.println("Unsupported jarmode '" + mode + "'");
        if (!Boolean.getBoolean(DISABLE_SYSTEM_EXIT)) {
            System.exit(1);
        }
    }

    private static boolean tryRun(JarMode candidate, String mode, String[] args) {
        if (candidate.accepts(mode)) {
            candidate.run(mode, args);
            return true;
        }
        return false;
    }

    private static @Nullable JarMode findDefault() {
        Class jarModeClass = ClassUtils.load((String)"infra.jarmode.layertools.LayerToolsJarMode");
        if (jarModeClass != null) {
            try {
                Constructor constructor = jarModeClass.getConstructor(new Class[0]);
                return (JarMode)constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw ExceptionUtils.sneakyThrow((Throwable)e);
            }
        }
        return null;
    }
}

