/*
 * Decompiled with CFR 0.152.
 */
package infra.app.loader;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

final class ClassPathIndexFile {
    private final @Nullable File root;
    private final Set<String> lines;

    private ClassPathIndexFile(@Nullable File root, List<String> lines) {
        this.root = root;
        this.lines = lines.stream().map(this::extractName).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private String extractName(String line) {
        if (line.startsWith("- \"") && line.endsWith("\"")) {
            return line.substring(3, line.length() - 1);
        }
        throw new IllegalStateException("Malformed classpath index line [" + line + "]");
    }

    int size() {
        return this.lines.size();
    }

    boolean containsEntry(@Nullable String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        return this.lines.contains(name);
    }

    List<URL> getUrls() {
        return this.lines.stream().map(this::asUrl).toList();
    }

    private URL asUrl(String line) {
        try {
            return new File(this.root, line).toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(ex);
        }
    }

    static @Nullable ClassPathIndexFile loadIfPossible(@Nullable File root, String location) throws IOException {
        return ClassPathIndexFile.loadIfPossible(root, new File(root, location));
    }

    private static @Nullable ClassPathIndexFile loadIfPossible(@Nullable File root, File indexFile) throws IOException {
        if (indexFile.exists() && indexFile.isFile()) {
            List<String> lines = Files.readAllLines(indexFile.toPath()).stream().filter(ClassPathIndexFile::lineHasText).toList();
            return new ClassPathIndexFile(root, lines);
        }
        return null;
    }

    private static boolean lineHasText(String line) {
        return !line.trim().isEmpty();
    }
}

