/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.app.loader.jarmode;

import cn.taketoday.app.loader.jarmode.JarMode;
import cn.taketoday.lang.Nullable;
import cn.taketoday.lang.TodayStrategies;
import cn.taketoday.util.ClassUtils;
import cn.taketoday.util.ExceptionUtils;
import java.lang.reflect.Constructor;
import java.util.List;

public final class JarModeLauncher {
    static final String DISABLE_SYSTEM_EXIT = JarModeLauncher.class.getName() + ".DISABLE_SYSTEM_EXIT";

    public static void main(String[] args) {
        String mode = System.getProperty("jarmode");
        List candidates = TodayStrategies.find(JarMode.class, (ClassLoader)ClassUtils.getDefaultClassLoader());
        for (JarMode candidate : candidates) {
            if (!JarModeLauncher.tryRun(candidate, mode, args)) continue;
            return;
        }
        JarMode jarMode = JarModeLauncher.findDefault();
        if (jarMode != null && JarModeLauncher.tryRun(jarMode, mode, args)) {
            return;
        }
        System.err.println("Unsupported jarmode '" + mode + "'");
        if (!Boolean.getBoolean(DISABLE_SYSTEM_EXIT)) {
            System.exit(1);
        }
    }

    private static boolean tryRun(JarMode candidate, String mode, String[] args) {
        if (candidate.accepts(mode)) {
            candidate.run(mode, args);
            return true;
        }
        return false;
    }

    @Nullable
    private static JarMode findDefault() {
        Class jarModeClass = ClassUtils.load((String)"cn.taketoday.jarmode.layertools.LayerToolsJarMode");
        if (jarModeClass != null) {
            try {
                Constructor constructor = jarModeClass.getConstructor(new Class[0]);
                return (JarMode)constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw ExceptionUtils.sneakyThrow((Throwable)e);
            }
        }
        return null;
    }
}

