/*
 * Decompiled with CFR 0.152.
 */
package cn.taketoday.app.loader;

import cn.taketoday.app.loader.ExecutableArchiveLauncher;
import cn.taketoday.app.loader.archive.Archive;

public class JarLauncher
extends ExecutableArchiveLauncher {
    static final Archive.EntryFilter NESTED_ARCHIVE_ENTRY_FILTER = entry -> {
        if (entry.isDirectory()) {
            return entry.getName().equals("APP-INF/classes/");
        }
        return entry.getName().startsWith("APP-INF/lib/");
    };

    public JarLauncher() {
    }

    protected JarLauncher(Archive archive) {
        super(archive);
    }

    @Override
    protected boolean isPostProcessingClassPathArchives() {
        return false;
    }

    @Override
    protected boolean isNestedArchive(Archive.Entry entry) {
        return NESTED_ARCHIVE_ENTRY_FILTER.matches(entry);
    }

    @Override
    protected String getArchiveEntryPathPrefix() {
        return "APP-INF/";
    }

    public static void main(String[] args) throws Exception {
        new JarLauncher().launch(args);
    }
}

