/*
 * Decompiled with CFR 0.152.
 */
package cn.t.extension.springboot.starters.web;

import cn.t.common.response.ResultVo;
import cn.t.common.service.ErrorInfo;
import cn.t.common.service.ErrorInfoEnum;
import cn.t.common.service.ServiceException;
import java.util.List;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private final Logger logger = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResultVo methodArgumentNotValid(MethodArgumentNotValidException e, HttpServletRequest request) {
        BindingResult bindingResult = e.getBindingResult();
        TreeMap<String, String> fieldErrorMap = this.buildErrorField(bindingResult);
        ResultVo vo = fieldErrorMap.size() > 0 && fieldErrorMap.firstEntry() != null ? ResultVo.buildFail((String)ErrorInfoEnum.BAD_PARAM.errorInfo.getCode(), (String)fieldErrorMap.firstEntry().getValue(), fieldErrorMap) : ResultVo.buildFail((ErrorInfo)ErrorInfoEnum.BAD_PARAM.errorInfo, this.buildErrorField(bindingResult));
        this.logger.warn("cat a MethodArgumentNotValidException, uri: " + request.getRequestURI() + ", {}", (Object)vo);
        return vo;
    }

    @ExceptionHandler(value={BindException.class})
    public ResultVo methodArgumentNotValid(BindException e, HttpServletRequest request) {
        BindingResult bindingResult = e.getBindingResult();
        ResultVo vo = ResultVo.buildFail((ErrorInfo)ErrorInfoEnum.BAD_PARAM.errorInfo, this.buildErrorField(bindingResult));
        this.logger.warn("cat a BindException, uri: " + request.getRequestURI() + ", {}", (Object)vo);
        return vo;
    }

    private TreeMap<String, String> buildErrorField(BindingResult bindingResult) {
        List objectErrorList = bindingResult.getAllErrors();
        TreeMap<String, String> errorFieldMap = new TreeMap<String, String>();
        objectErrorList.forEach(error -> {
            if (error instanceof FieldError) {
                errorFieldMap.put(((FieldError)error).getField(), error.getDefaultMessage());
            }
        });
        return errorFieldMap;
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public ResultVo noHandlerFound(NoHandlerFoundException e, HttpServletRequest request) {
        this.logger.error("cat a NoHandlerFoundException: " + request.getRequestURI(), (Throwable)e);
        return ResultVo.buildFail((ErrorInfo)ErrorInfoEnum.SOURCE_NOT_FOUND.errorInfo);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResultVo messageNotReadable(HttpMessageNotReadableException e, HttpServletRequest request) {
        this.logger.error("cat a HttpMessageNotReadableException: " + request.getRequestURI(), (Throwable)e);
        return ResultVo.buildFail((ErrorInfo)ErrorInfoEnum.BAD_PARAM.errorInfo);
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ResultVo methodNotSupport(HttpRequestMethodNotSupportedException e, HttpServletRequest request) {
        this.logger.error("cat a HttpRequestMethodNotSupportedException: " + request.getRequestURI(), (Throwable)e);
        return ResultVo.buildFail((ErrorInfo)ErrorInfoEnum.METHOD_NOT_SUPPORT.errorInfo);
    }

    @ExceptionHandler(value={HttpMediaTypeNotAcceptableException.class})
    public ResultVo mediaTypeNotAcceptable(HttpMediaTypeNotAcceptableException e, HttpServletRequest request) {
        this.logger.error("cat a HttpMediaTypeNotAcceptableException: " + request.getRequestURI(), (Throwable)e);
        return ResultVo.buildFail((ErrorInfo)ErrorInfoEnum.MEDIA_TYPE_NOT_SUPPORT.errorInfo);
    }

    @ExceptionHandler(value={ServiceException.class})
    public ResultVo exception(ServiceException e, HttpServletRequest request) {
        if (!StringUtils.hasText((String)e.getCode())) {
            return ResultVo.buildFail();
        }
        this.logger.warn("\u4e1a\u52a1\u5f02\u5e38, uri: {}, code: {}, msg: {}, data: {}", new Object[]{request.getRequestURI(), e.getCode(), e.getMessage(), e.getData()});
        if ("employee_no_authority".equals(e.getCode())) {
            return ResultVo.buildFail((String)e.getCode(), (String)("\u65e0\u64cd\u4f5c\u6743\u9650: " + e.getData()));
        }
        return ResultVo.buildFail((String)e.getCode(), (String)e.getMessage(), (Object)e.getData());
    }

    @ExceptionHandler(value={Throwable.class})
    public ResultVo exception(Throwable t, HttpServletRequest request) {
        this.logger.error("catch a exception: " + request.getRequestURI(), t);
        return ResultVo.buildFail();
    }
}

