/*
 * Decompiled with CFR 0.152.
 */
package cn.t.extension.springboot.starters.web;

import cn.t.common.response.ResultVo;
import cn.t.common.service.ErrorInfo;
import cn.t.common.service.ErrorInfoEnum;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.autoconfigure.web.ErrorProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.AbstractErrorController;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorViewResolver;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RequestMapping(value={"${server.error.path:${error.path:/error}}"})
@RestController
public class GlobalErrorController
extends AbstractErrorController {
    private final ErrorProperties errorProperties;

    public GlobalErrorController(ErrorAttributes errorAttributes, ErrorProperties errorProperties) {
        this(errorAttributes, errorProperties, Collections.emptyList());
    }

    public GlobalErrorController(ErrorAttributes errorAttributes, ErrorProperties errorProperties, List<ErrorViewResolver> errorViewResolvers) {
        super(errorAttributes, errorViewResolvers);
        Assert.notNull((Object)errorProperties, (String)"ErrorProperties must not be null");
        this.errorProperties = errorProperties;
    }

    public String getErrorPath() {
        return null;
    }

    @RequestMapping(produces={"text/html"})
    public ModelAndView errorHtml(HttpServletRequest request, HttpServletResponse response) {
        HttpStatus status = this.getStatus(request);
        Map model = Collections.unmodifiableMap(this.getErrorAttributes(request, this.getErrorAttributeOptions(request, MediaType.TEXT_HTML)));
        response.setStatus(status.value());
        ModelAndView modelAndView = this.resolveErrorView(request, response, status, model);
        return modelAndView != null ? modelAndView : new ModelAndView("error", model);
    }

    @RequestMapping(produces={"application/json"})
    public ResultVo error(HttpServletRequest request) {
        HttpStatus status = this.getStatus(request);
        ErrorInfoEnum infoEnum = ErrorInfoEnum.getErrorInfoEnum((String)String.valueOf(status.value()));
        if (infoEnum != null) {
            return ResultVo.buildFail((ErrorInfo)infoEnum.errorInfo);
        }
        return ResultVo.buildFail((ErrorInfo)ErrorInfoEnum.SERVER_INTERNAL_ERROR.errorInfo);
    }

    protected ErrorAttributeOptions getErrorAttributeOptions(HttpServletRequest request, MediaType mediaType) {
        ErrorAttributeOptions options = ErrorAttributeOptions.defaults();
        if (this.errorProperties.isIncludeException()) {
            options = options.including(new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.EXCEPTION});
        }
        if (this.isIncludeStackTrace(request, mediaType)) {
            options = options.including(new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.STACK_TRACE});
        }
        if (this.isIncludeMessage(request, mediaType)) {
            options = options.including(new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.MESSAGE});
        }
        if (this.isIncludeBindingErrors(request, mediaType)) {
            options = options.including(new ErrorAttributeOptions.Include[]{ErrorAttributeOptions.Include.BINDING_ERRORS});
        }
        return options;
    }

    protected boolean isIncludeStackTrace(HttpServletRequest request, MediaType produces) {
        switch (this.getErrorProperties().getIncludeStacktrace()) {
            case ALWAYS: {
                return true;
            }
            case ON_PARAM: {
                return this.getTraceParameter(request);
            }
        }
        return false;
    }

    protected boolean isIncludeMessage(HttpServletRequest request, MediaType produces) {
        switch (this.getErrorProperties().getIncludeMessage()) {
            case ALWAYS: {
                return true;
            }
            case ON_PARAM: {
                return this.getMessageParameter(request);
            }
        }
        return false;
    }

    protected boolean isIncludeBindingErrors(HttpServletRequest request, MediaType produces) {
        switch (this.getErrorProperties().getIncludeBindingErrors()) {
            case ALWAYS: {
                return true;
            }
            case ON_PARAM: {
                return this.getErrorsParameter(request);
            }
        }
        return false;
    }

    protected ErrorProperties getErrorProperties() {
        return this.errorProperties;
    }
}

