/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.validator;

import cn.t.util.common.CollectionUtil;
import cn.t.util.common.StringUtil;
import cn.t.util.internationalize.MessageUtil;
import cn.t.util.validator.FieldError;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;

public class ValidateUtil {
    private static final Validator validator = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(true)).buildValidatorFactory().getValidator();
    private static final String BUNDLE_NAME = "i18n/field-error-msg";

    public static <T> Set<FieldError> validate(T param, boolean failFast) {
        Set violations = validator.validate(param, new Class[0]);
        if (!CollectionUtil.isEmpty((Collection)violations)) {
            HashSet<FieldError> fieldErrorSet = new HashSet<FieldError>();
            for (ConstraintViolation violation : violations) {
                String i18n;
                String property = violation.getPropertyPath().toString();
                String msg = violation.getMessage();
                if (!StringUtil.isEmpty((String)msg) && !StringUtil.isEmpty((String)(i18n = MessageUtil.getString((String)BUNDLE_NAME, (String)msg)))) {
                    msg = i18n;
                }
                fieldErrorSet.add(new FieldError(property, msg));
            }
            return fieldErrorSet;
        }
        return Collections.emptySet();
    }
}

