/*
 * Decompiled with CFR 0.152.
 */
package cn.t.extension.springboot.starters.trace;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.MDC;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class WebTraceFilter
extends OncePerRequestFilter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull FilterChain chain) throws IOException, ServletException {
        String spanId;
        String clientId;
        String traceId = request.getHeader("X-Request-Id");
        if (StringUtils.hasText((String)traceId)) {
            MDC.put((String)"traceId", (String)traceId);
        }
        if (StringUtils.hasText((String)(clientId = request.getHeader("X-Request-Client-Id")))) {
            MDC.put((String)"clientId", (String)clientId);
        }
        String userId = request.getHeader("X-Request-User-Id");
        if (StringUtils.hasText((String)clientId)) {
            MDC.put((String)"userId", (String)userId);
        }
        if (StringUtils.hasText((String)(spanId = request.getHeader("X-Request-Span-Id")))) {
            MDC.put((String)"spanId", (String)spanId);
        }
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            MDC.remove((String)"traceId");
            MDC.remove((String)"clientId");
            MDC.remove((String)"userId");
            MDC.remove((String)"spanId");
        }
    }
}

