/*
 * Decompiled with CFR 0.152.
 */
package cn.t.extension.springboot.starters.trace;

import java.util.Map;
import org.slf4j.MDC;
import org.springframework.core.task.TaskDecorator;
import org.springframework.lang.NonNull;
import org.springframework.util.CollectionUtils;

public class TracedTaskDecorator
implements TaskDecorator {
    @NonNull
    public Runnable decorate(@NonNull Runnable runnable) {
        Map context = MDC.getCopyOfContextMap();
        if (!CollectionUtils.isEmpty((Map)context)) {
            return () -> {
                MDC.setContextMap((Map)context);
                try {
                    runnable.run();
                }
                finally {
                    MDC.clear();
                }
            };
        }
        return runnable;
    }
}

