/*
 * Decompiled with CFR 0.152.
 */
package cn.t.extension.springboot.starters.trace;

import cn.t.util.common.StringUtil;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Collection;
import java.util.Map;
import org.slf4j.MDC;
import org.springframework.util.CollectionUtils;

public class FeignTraceInterceptor
implements RequestInterceptor {
    public void apply(RequestTemplate template) {
        String spanId;
        String userId;
        String clientId;
        String traceId;
        Map headers = template.headers();
        if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("X-Request-Id"))) && !StringUtil.isEmpty((String)(traceId = MDC.get((String)"traceId")))) {
            template.header("X-Request-Id", new String[]{traceId});
        }
        if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("X-Request-Client-Id"))) && !StringUtil.isEmpty((String)(clientId = MDC.get((String)"clientId")))) {
            template.header("X-Request-Client-Id", new String[]{clientId});
        }
        if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("X-Request-User-Id"))) && !StringUtil.isEmpty((String)(userId = MDC.get((String)"userId")))) {
            template.header("X-Request-User-Id", new String[]{userId});
        }
        if (CollectionUtils.isEmpty((Collection)((Collection)headers.get("X-Request-Span-Id"))) && !StringUtil.isEmpty((String)(spanId = MDC.get((String)"spanId")))) {
            template.header("X-Request-Span-Id", new String[]{spanId});
        }
    }
}

