/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.society.area;

import cn.t.util.common.StringUtil;
import cn.t.util.doc.AbstractReadExcelCallBack;
import cn.t.util.doc.ExcelUtil;
import cn.t.util.doc.ReadExcelCallBack;
import cn.t.util.society.ChineseUtil;
import java.io.IOException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;

public class AdministrativeCodeUtil {
    public static void generateAdministrativeCode(String path) throws IOException, InvalidFormatException {
        ExcelUtil.readWorkbook((String)path, (ReadExcelCallBack)new AbstractReadExcelCallBack(){
            private DataFormatter formatter = new DataFormatter();
            private String provinceCode;
            private String cityCode;
            private String countyCode;
            private String provinceAdministrative;
            private String provinceAdministrativeName;
            private String cityAdministrative;
            private String cityAdministrativeName;

            public void readCell(Cell cell, int index) {
                if (index == 0) {
                    String code = this.formatter.formatCellValue(cell).trim();
                    if (!StringUtil.isEmpty((String)(code = code.replaceAll("\\u00A0", ""))) && StringUtil.isAllNumeric((String)code)) {
                        if (this.provinceCode == null) {
                            this.provinceCode = code.substring(0, 2);
                        } else if (this.cityCode == null) {
                            this.cityCode = code.substring(2, 4);
                        } else {
                            String pCode = code.substring(0, 2);
                            if (!this.provinceCode.equals(pCode)) {
                                this.provinceCode = pCode;
                                this.cityCode = null;
                                this.provinceAdministrative = null;
                                this.provinceAdministrativeName = null;
                                this.cityAdministrative = null;
                                this.cityAdministrative = null;
                            } else {
                                String cCode = code.substring(2, 4);
                                if (!this.cityCode.equals(cCode)) {
                                    this.cityCode = cCode;
                                    this.cityAdministrative = null;
                                    this.cityAdministrative = null;
                                } else {
                                    this.countyCode = code;
                                }
                            }
                        }
                    }
                } else if (index == 1) {
                    String name = this.formatter.formatCellValue(cell).trim();
                    if (StringUtil.isEmpty((String)(name = name.replaceAll("\\u00A0", "")))) {
                        throw new RuntimeException("\u5730\u533a\u540d\u79f0\u4e3a\u7a7a");
                    }
                    if (this.countyCode != null) {
                        System.out.println(String.format("private static final AdministrativeCode %s = new AdministrativeCode(\"%s\", \"%s\", %s);", this.cityAdministrative + "_" + ChineseUtil.toPinyin(name), this.cityAdministrativeName + "-" + name, this.countyCode, this.cityAdministrative));
                        this.countyCode = null;
                    } else if (this.cityCode != null) {
                        this.cityAdministrative = this.provinceAdministrative + "_" + ChineseUtil.toPinyin(name);
                        this.cityAdministrativeName = this.provinceAdministrativeName + "-" + name;
                        System.out.println(String.format("private static final AdministrativeCode %s = new AdministrativeCode(\"%s\", \"%s\", %s);", this.cityAdministrative, this.cityAdministrativeName, this.provinceCode + this.cityCode, this.provinceAdministrative));
                    } else {
                        this.provinceAdministrative = ChineseUtil.toPinyin(name);
                        this.provinceAdministrativeName = name;
                        System.out.println(String.format("private static final AdministrativeCode %s = new AdministrativeCode(\"%s\", \"%s\", null);", this.provinceAdministrative, name, this.provinceCode));
                    }
                }
            }
        });
    }
}

