/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.society;

import cn.t.util.common.digital.CharUtil;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdCardUtil {
    private static final Logger logger = LoggerFactory.getLogger(IdCardUtil.class);
    private static final byte[] coefficients = new byte[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private static final char[] tail = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};

    public static boolean isValid(String idCardNum) {
        logger.debug("id card number: {}", (Object)idCardNum);
        idCardNum = idCardNum.trim().replace(" ", "");
        char[] chars = idCardNum.toCharArray();
        char checkSum = IdCardUtil.calculateCheckSum(chars);
        return checkSum == chars[17];
    }

    public static char calculateCheckSum(char[] chars) {
        int[] results = new int[chars.length];
        for (int i = 0; i < 17; ++i) {
            results[i] = CharUtil.decAsciiCharToInt((char)chars[i]) * coefficients[i];
        }
        int sum = Arrays.stream(results).sum();
        logger.debug("sum: {}", (Object)sum);
        char checkSum = tail[sum % 11];
        logger.debug("check sum: {}", (Object)Character.valueOf(checkSum));
        return checkSum;
    }
}

