/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.society;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChineseUtil {
    private static final Logger logger = LoggerFactory.getLogger(ChineseUtil.class);

    public static String toPinyin(String hanzi) {
        char[] chars = hanzi.trim().toCharArray();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(HanyuPinyinCaseType.UPPERCASE);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        defaultFormat.setVCharType(HanyuPinyinVCharType.WITH_V);
        StringBuilder sb = new StringBuilder();
        try {
            for (int i = 0; i < chars.length; ++i) {
                if (String.valueOf(chars[i]).matches("[\u4e00-\u9fa5]+")) {
                    sb.append(PinyinHelper.toHanyuPinyinStringArray((char)chars[i], (HanyuPinyinOutputFormat)defaultFormat)[0]);
                    continue;
                }
                sb.append(chars[i]);
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            System.out.println("\u5b57\u7b26\u4e0d\u80fd\u8f6c\u6210\u6c49\u8bed\u62fc\u97f3");
        }
        return sb.toString();
    }

    public static String getFirstLettersUp(String hanzi) {
        return ChineseUtil.getFirstLetters(hanzi, HanyuPinyinCaseType.UPPERCASE);
    }

    public static String getFirstLettersLo(String hanzi) {
        return ChineseUtil.getFirstLetters(hanzi, HanyuPinyinCaseType.LOWERCASE);
    }

    private static String getFirstLetters(String hanzi, HanyuPinyinCaseType caseType) {
        char[] chars = hanzi.trim().toCharArray();
        StringBuilder sb = new StringBuilder();
        HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
        defaultFormat.setCaseType(caseType);
        defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        try {
            for (char c : chars) {
                String str = String.valueOf(c);
                if (str.matches("[\u4e00-\u9fa5]+")) {
                    sb.append(PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)defaultFormat)[0].substring(0, 1));
                    continue;
                }
                if (str.matches("[0-9]+")) {
                    sb.append(c);
                    continue;
                }
                if (str.matches("[a-zA-Z]+")) {
                    sb.append(c);
                    continue;
                }
                sb.append(c);
            }
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            logger.error("\u5b57\u7b26\u4e0d\u80fd\u8f6c\u6210\u6c49\u8bed\u62fc\u97f3", (Throwable)e);
        }
        return sb.toString();
    }
}

