/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.security.message.encryption.dh;

import cn.t.util.security.message.AlgorithmUtil;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyAgreement;

public class DhUtil {
    public static PublicKey convertEncodedBytesToPublicKey(byte[] encodedBytes) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = AlgorithmUtil.generateKeyFactory("DH");
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(encodedBytes);
        return keyFactory.generatePublic(x509EncodedKeySpec);
    }

    public static KeyAgreement generateKeyAgreement(PrivateKey privateKey, PublicKey publicKey) throws NoSuchAlgorithmException, InvalidKeyException {
        KeyAgreement keyAgreement = KeyAgreement.getInstance("DH");
        keyAgreement.init(privateKey);
        keyAgreement.doPhase(publicKey, true);
        return keyAgreement;
    }

    public static Key generateSecretKey(PrivateKey privateKey, PublicKey publicKey, String algorithm) throws InvalidKeyException, NoSuchAlgorithmException {
        KeyAgreement keyAgreement = DhUtil.generateKeyAgreement(privateKey, publicKey);
        return keyAgreement.generateSecret(algorithm);
    }
}

