/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.security.message;

import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;

public class AlgorithmUtil {
    public static KeyGenerator generateKeyGenerator(String algorithm, int length, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyGenerator keyGenerator = provider != null ? KeyGenerator.getInstance(algorithm, provider) : KeyGenerator.getInstance(algorithm);
        if (length > 0) {
            keyGenerator.init(length);
        }
        return keyGenerator;
    }

    public static KeyGenerator generateKeyGenerator(String algorithm, int length) throws NoSuchAlgorithmException, NoSuchProviderException {
        return AlgorithmUtil.generateKeyGenerator(algorithm, length, null);
    }

    public static KeyGenerator generateKeyGenerator(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        return AlgorithmUtil.generateKeyGenerator(algorithm, -1, null);
    }

    public static Key generateSecretKey(String algorithm, int length, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        return AlgorithmUtil.generateKeyGenerator(algorithm, length, provider).generateKey();
    }

    public static Key generateSecretKey(String algorithm, int length) throws NoSuchAlgorithmException, NoSuchProviderException {
        return AlgorithmUtil.generateKeyGenerator(algorithm, length).generateKey();
    }

    public static Key generateSecretKey(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        return AlgorithmUtil.generateKeyGenerator(algorithm).generateKey();
    }

    public static KeyPairGenerator generateKeyPairGenerator(String algorithm, int length) throws NoSuchAlgorithmException {
        KeyPairGenerator senderKeyPairGenerator = KeyPairGenerator.getInstance(algorithm);
        senderKeyPairGenerator.initialize(length);
        return senderKeyPairGenerator;
    }

    public static KeyPairGenerator generateKeyPairGenerator(String algorithm, AlgorithmParameterSpec params, SecureRandom secureRandom) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        KeyPairGenerator senderKeyPairGenerator = KeyPairGenerator.getInstance(algorithm);
        if (secureRandom != null) {
            senderKeyPairGenerator.initialize(params, secureRandom);
        } else {
            senderKeyPairGenerator.initialize(params);
        }
        return senderKeyPairGenerator;
    }

    public static KeyPairGenerator generateKeyPairGenerator(String algorithm, AlgorithmParameterSpec params) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        return AlgorithmUtil.generateKeyPairGenerator(algorithm, params, null);
    }

    public static KeyPair generateKeyPair(String algorithm, int length) throws NoSuchAlgorithmException {
        KeyPairGenerator senderKeyPairGenerator = AlgorithmUtil.generateKeyPairGenerator(algorithm, length);
        return senderKeyPairGenerator.generateKeyPair();
    }

    public static KeyPair generateKeyPair(String algorithm, AlgorithmParameterSpec params, SecureRandom secureRandom) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        KeyPairGenerator senderKeyPairGenerator = AlgorithmUtil.generateKeyPairGenerator(algorithm, params, secureRandom);
        return senderKeyPairGenerator.generateKeyPair();
    }

    public static KeyPair generateKeyPair(String algorithm, AlgorithmParameterSpec params) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        return AlgorithmUtil.generateKeyPair(algorithm, params, null);
    }

    public static KeyFactory generateKeyFactory(String algorithm) throws NoSuchAlgorithmException {
        return KeyFactory.getInstance(algorithm);
    }

    public static byte[] generateSecretKeyEncodedBytes(String algorithm, int length, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        return AlgorithmUtil.generateSecretKey(algorithm, length, provider).getEncoded();
    }

    public static byte[] generateSecretKeyEncodedBytes(String algorithm, int length) throws NoSuchAlgorithmException, NoSuchProviderException {
        return AlgorithmUtil.generateSecretKey(algorithm, length).getEncoded();
    }

    public static byte[] generateSecretKeyEncodedBytes(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        return AlgorithmUtil.generateSecretKey(algorithm).getEncoded();
    }

    public static byte[] encrypt(Cipher cipher, Key key, AlgorithmParameterSpec algorithmParameterSpec, byte[] content) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            cipher.init(1, key, algorithmParameterSpec);
        } else {
            cipher.init(1, key);
        }
        return cipher.doFinal(content);
    }

    public static byte[] encrypt(Cipher cipher, Key key, byte[] content) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException {
        return AlgorithmUtil.encrypt(cipher, key, null, content);
    }

    public static byte[] decrypt(Cipher cipher, Key key, AlgorithmParameterSpec algorithmParameterSpec, byte[] content) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            cipher.init(2, key, algorithmParameterSpec);
        } else {
            cipher.init(2, key);
        }
        return cipher.doFinal(content);
    }

    public static byte[] decrypt(Cipher cipher, Key key, byte[] content) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException {
        return AlgorithmUtil.decrypt(cipher, key, null, content);
    }

    public static AlgorithmParameterGenerator generateAlgorithmParameterGenerator(String algorithm) throws NoSuchAlgorithmException {
        return AlgorithmParameterGenerator.getInstance(algorithm);
    }

    public static AlgorithmParameters generateAlgorithmParameters(String algorithm, int length) throws NoSuchAlgorithmException {
        AlgorithmParameterGenerator algorithmParameterGenerator = AlgorithmUtil.generateAlgorithmParameterGenerator(algorithm);
        algorithmParameterGenerator.init(length);
        return algorithmParameterGenerator.generateParameters();
    }

    public static AlgorithmParameterSpec generateAlgorithmParameterSpec(String algorithm, int length, Class<? extends AlgorithmParameterSpec> type) throws NoSuchAlgorithmException, InvalidParameterSpecException {
        AlgorithmParameters algorithmParameters = AlgorithmUtil.generateAlgorithmParameters(algorithm, length);
        return algorithmParameters.getParameterSpec(type);
    }

    public static byte[] generateSeedBytes(int length) {
        SecureRandom secureRandom = new SecureRandom();
        return secureRandom.generateSeed(length);
    }

    public static Mac generateMac(String algorithm, Key secretKey) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance(algorithm);
        mac.init(secretKey);
        return mac;
    }

    public static Signature generateSenderSignature(String algorithm, PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeyException {
        Signature signature = Signature.getInstance(algorithm);
        signature.initSign(privateKey);
        return signature;
    }

    public static byte[] signData(String algorithm, PrivateKey privateKey, byte[] content) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        Signature signature = AlgorithmUtil.generateSenderSignature(algorithm, privateKey);
        signature.update(content);
        return signature.sign();
    }

    public static Signature generateReceiverSignature(String algorithm, PublicKey publicKey) throws NoSuchAlgorithmException, InvalidKeyException {
        Signature signature = Signature.getInstance(algorithm);
        signature.initVerify(publicKey);
        return signature;
    }

    public static boolean verifySign(String algorithm, PublicKey publicKey, byte[] content, byte[] sign) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
        Signature signature = AlgorithmUtil.generateReceiverSignature(algorithm, publicKey);
        signature.update(content);
        return signature.verify(sign);
    }
}

