package cn.t.util.security.message.encryption.dh;

/**
 * DH(Diffie-Hellman)算法
 * 1.接受方利用发送方的公钥构建自己的密钥对
 * 2.本地密钥构建方式: 自己密钥 + 对方公钥
 * <p>
 * 理解:
 * 假设发送方是 A,接受方是 B.A首先生成公钥和密钥,将公钥发送出去,B接收到 A发送的公钥,然后利用该公钥生成自己的公钥和密钥,再将自己的公钥 发送给 A,
 * 这个时候 A 拥有了自己的公钥,密钥和 B 的公钥,B 拥有了自己的公钥密钥和 A 的公钥.
 * 之后,A就可以使用 A自己的密钥 + B的公钥 获取到本地的密钥,B也是如此,这个时候A和B生成的本地密钥其实是相同的,这样的话也就变成了用相同的密钥加密,
 * 用相同的密钥解密.而且这样的话,我们数据传递过程中传递的是 A 和 B 的公钥,就算被黑客截取了也无济于事,他们不可能凭借着公钥将数据解密,从而保证了数据的安全性.
 */
