/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.media.code.qrcode.decoder.reedsolomon;

public final class BCH_15_5 {
    private static final int GX = 311;
    private static final BCH_15_5 instance = new BCH_15_5();
    private int[] trueCodes = new int[32];

    private BCH_15_5() {
        this.makeTrueCodes();
    }

    public static BCH_15_5 getInstance() {
        return instance;
    }

    private static int calcDistance(int c1, int c2) {
        int n = 0;
        for (int wk = c1 ^ c2; wk != 0; wk >>= 1) {
            if ((wk & 1) == 0) continue;
            ++n;
        }
        return n;
    }

    private void makeTrueCodes() {
        for (int i = 0; i < this.trueCodes.length; ++i) {
            this.trueCodes[i] = this.slowEncode(i);
        }
    }

    private int slowEncode(int data) {
        int wk = 0;
        data <<= 5;
        for (int i = 0; i < 5; ++i) {
            if ((((wk <<= 1) ^ (data <<= 1)) & 0x400) == 0) continue;
            wk ^= 0x137;
        }
        return data & 0x7C00 | wk & 0x3FF;
    }

    public int encode(int data) {
        return this.trueCodes[data & 0x1F];
    }

    public int decode(int data) {
        data &= Short.MAX_VALUE;
        for (int i = 0; i < this.trueCodes.length; ++i) {
            int code = this.trueCodes[i];
            if (BCH_15_5.calcDistance(data, code) > 3) continue;
            return code;
        }
        return -1;
    }
}

