package cn.t.util.media.code.qrcode.encoder;

import cn.t.util.media.code.TwoDimensionCodeConfig;

import java.awt.*;

public class QrCodeTwoDimensionCodeConfig extends TwoDimensionCodeConfig {

    /**
     * 纠错级别
     */
    private char errorCorrectLevel = 'M';

    /**
     * 填充模式
     * N代表数字, A代表a-z, B代表其他字符
     */
    private char qrcodeEncodeMode = 'B';

    /**
     * 版本号
     */
    private int version;

    /**
     * 背景颜色
     */
    private Color backgroundColor = Color.WHITE;

    /**
     * 二维码填充颜色
     */
    private Color fillColor = Color.BLACK;

    /**
     * 偏移量
     */
    private int pixOff = 2;

    public char getErrorCorrectLevel() {
        return errorCorrectLevel;
    }

    public void setErrorCorrectLevel(char errorCorrectLevel) {
        this.errorCorrectLevel = errorCorrectLevel;
    }

    public char getQrcodeEncodeMode() {
        return qrcodeEncodeMode;
    }

    public void setQrcodeEncodeMode(char qrcodeEncodeMode) {
        this.qrcodeEncodeMode = qrcodeEncodeMode;
    }

    public int getVersion() {
        return version;
    }

    public void setVersion(int version) {
        this.version = version;
        setWidth(67 + 12 * (version - 1));
        setHeight(67 + 12 * (version - 1));
    }

    public Color getBackgroundColor() {
        return backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getFillColor() {
        return fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    public int getPixOff() {
        return pixOff;
    }

    public void setPixOff(int pixOff) {
        this.pixOff = pixOff;
    }
}
