/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.media.video.mp4.builder;

import cn.t.util.digital.ByteSequence;
import cn.t.util.media.video.mp4.builder.AbstractBoxBuilder;
import cn.t.util.media.video.mp4.enums.BoxType;
import cn.t.util.media.video.mp4.modal.Box;
import cn.t.util.media.video.mp4.modal.level3.TkhdBox;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TkhdBoxBuilder
extends AbstractBoxBuilder {
    @Override
    public List<Box> build(byte[] bs) throws IOException {
        ArrayList<Box> boxList = new ArrayList<Box>();
        TkhdBox tkhdBox = new TkhdBox();
        boxList.add(tkhdBox);
        ByteSequence byteSequence = new ByteSequence(bs);
        tkhdBox.setVersion(byteSequence.readByte());
        byte[] flags = new byte[3];
        long l = byteSequence.read(flags);
        if (l < (long)flags.length) {
            throw new EOFException("bytes not enough");
        }
        tkhdBox.setFlag(flags);
        tkhdBox.setCreationTime(byteSequence.readInt());
        tkhdBox.setModificationTime(byteSequence.readInt());
        tkhdBox.setTrackId(byteSequence.readInt());
        l = byteSequence.skip(4L);
        if (l < 4L) {
            throw new EOFException("bytes not enough");
        }
        tkhdBox.setDuration(byteSequence.readInt());
        l = byteSequence.skip(8L);
        if (l < 8L) {
            throw new EOFException("bytes not enough");
        }
        tkhdBox.setLayer(byteSequence.readShort());
        tkhdBox.setAlternateGroup(byteSequence.readShort());
        tkhdBox.setVolume(byteSequence.readShort());
        l = byteSequence.skip(2L);
        if (l < 2L) {
            throw new EOFException("bytes not enough");
        }
        byte[] matrix = new byte[36];
        l = byteSequence.read(matrix);
        if (l < (long)matrix.length) {
            throw new EOFException("bytes not enough");
        }
        tkhdBox.setMatrix(matrix);
        tkhdBox.setWidth(byteSequence.readInt());
        tkhdBox.setHeight(byteSequence.readInt());
        return boxList;
    }

    @Override
    public String getSupport() {
        return BoxType.TKHD.value;
    }
}

