/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.media.video.mp4.builder;

import cn.t.util.digital.ByteSequence;
import cn.t.util.media.video.mp4.builder.AbstractBoxBuilder;
import cn.t.util.media.video.mp4.enums.BoxType;
import cn.t.util.media.video.mp4.modal.Box;
import cn.t.util.media.video.mp4.modal.level2.MvhdBox;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MvhdBuilder
extends AbstractBoxBuilder {
    @Override
    public List<Box> build(byte[] content) throws IOException {
        ArrayList<Box> boxList = new ArrayList<Box>();
        MvhdBox mvhdBox = new MvhdBox();
        boxList.add(mvhdBox);
        ByteSequence byteSequence = new ByteSequence(content);
        mvhdBox.setVersion(byteSequence.readByte());
        byte[] flags = new byte[3];
        long l = byteSequence.read(flags);
        if (l < (long)flags.length) {
            throw new EOFException("bytes not enough");
        }
        mvhdBox.setFlag(flags);
        mvhdBox.setCreationTime(byteSequence.readInt());
        mvhdBox.setModificationTIme(byteSequence.readInt());
        mvhdBox.setTimeScale(byteSequence.readInt());
        mvhdBox.setDuration(byteSequence.readInt());
        mvhdBox.setRate(byteSequence.readInt());
        mvhdBox.setVolume(byteSequence.readShort());
        l = byteSequence.skip(10L);
        if (l < 10L) {
            throw new EOFException("bytes not enough");
        }
        byte[] matrix = new byte[36];
        l = byteSequence.read(matrix);
        if (l < (long)matrix.length) {
            throw new EOFException("bytes not enough");
        }
        mvhdBox.setMatrix(matrix);
        l = byteSequence.skip(24L);
        if (l < 24L) {
            throw new EOFException("bytes not enough");
        }
        mvhdBox.setNextTrackId(byteSequence.readInt());
        return boxList;
    }

    @Override
    public String getSupport() {
        return BoxType.MVHD.value;
    }
}

