/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.media.code.qrcode.encoder;

import cn.t.util.io.FileUtil;
import java.io.BufferedInputStream;
import java.io.InputStream;

public class Qrcode {
    private static final String QR_CODE_DATA_PATH = "/qrcode-data";
    private char qrcodeErrorCorrect = (char)77;
    private char qrcodeEncodeMode = (char)66;
    private int qrcodeVersion = 0;
    private int qrcodeStructureappendN = 0;
    private int qrcodeStructureappendM = 0;
    private int qrcodeStructureappendParity = 0;
    private String qrcodeStructureappendOriginaldata = "";

    private static byte[] divideDataBy8Bits(int[] data, byte[] bits, int maxDataCodewords) {
        boolean flag;
        int i;
        int l1 = bits.length;
        int codewordsCounter = 0;
        int remainingBits = 8;
        int max = 0;
        if (l1 != data.length) {
            // empty if block
        }
        for (int i2 = 0; i2 < l1; ++i2) {
            max += bits[i2];
        }
        int l2 = (max - 1) / 8 + 1;
        byte[] codewords = new byte[maxDataCodewords];
        for (i = 0; i < l2; ++i) {
            codewords[i] = 0;
        }
        for (i = 0; i < l1; ++i) {
            int buffer = data[i];
            int bufferBits = bits[i];
            flag = true;
            if (bufferBits == 0) break;
            while (flag) {
                if (remainingBits > bufferBits) {
                    codewords[codewordsCounter] = (byte)(codewords[codewordsCounter] << bufferBits | buffer);
                    remainingBits -= bufferBits;
                    flag = false;
                    continue;
                }
                codewords[codewordsCounter] = (byte)(codewords[codewordsCounter] << remainingBits | buffer >> (bufferBits -= remainingBits));
                if (bufferBits == 0) {
                    flag = false;
                } else {
                    buffer &= (1 << bufferBits) - 1;
                    flag = true;
                }
                ++codewordsCounter;
                remainingBits = 8;
            }
        }
        if (remainingBits != 8) {
            codewords[codewordsCounter] = (byte)(codewords[codewordsCounter] << remainingBits);
        } else {
            --codewordsCounter;
        }
        if (codewordsCounter < maxDataCodewords - 1) {
            flag = true;
            while (codewordsCounter < maxDataCodewords - 1) {
                codewords[++codewordsCounter] = flag ? -20 : 17;
                flag = !flag;
            }
        }
        return codewords;
    }

    private static byte[] calculateRSECC(byte[] codewords, byte rsEccCodewords, byte[] rsBlockOrder, int maxDataCodewords, int maxCodewords) {
        byte[][] rsCalTableArray = new byte[256][rsEccCodewords];
        try {
            String filename = "/qrcode-data/rsc" + Byte.toString(rsEccCodewords) + ".dat";
            InputStream fis = FileUtil.getResourceInputStream(Qrcode.class, (String)filename);
            BufferedInputStream bis = new BufferedInputStream(fis);
            for (int i = 0; i < 256; ++i) {
                bis.read(rsCalTableArray[i]);
            }
            bis.close();
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int i = 0;
        int j = 0;
        int rsBlockNumber = 0;
        byte[][] rsTemp = new byte[rsBlockOrder.length][];
        byte[] res = new byte[maxCodewords];
        System.arraycopy(codewords, 0, res, 0, codewords.length);
        for (i = 0; i < rsBlockOrder.length; ++i) {
            rsTemp[i] = new byte[(rsBlockOrder[i] & 0xFF) - rsEccCodewords];
        }
        for (i = 0; i < maxDataCodewords; ++i) {
            rsTemp[rsBlockNumber][j] = codewords[i];
            if (++j < (rsBlockOrder[rsBlockNumber] & 0xFF) - rsEccCodewords) continue;
            j = 0;
            ++rsBlockNumber;
        }
        for (rsBlockNumber = 0; rsBlockNumber < rsBlockOrder.length; ++rsBlockNumber) {
            int rsDataCodewords;
            byte[] rsTempData = (byte[])rsTemp[rsBlockNumber].clone();
            int rsCodewords = rsBlockOrder[rsBlockNumber] & 0xFF;
            for (j = rsDataCodewords = rsCodewords - rsEccCodewords; j > 0; --j) {
                byte[] rsTempNew;
                byte first = rsTempData[0];
                if (first != 0) {
                    byte[] leftChr = new byte[rsTempData.length - 1];
                    System.arraycopy(rsTempData, 1, leftChr, 0, rsTempData.length - 1);
                    byte[] cal = rsCalTableArray[first & 0xFF];
                    rsTempData = Qrcode.calculateByteArrayBits(leftChr, cal, "xor");
                    continue;
                }
                if (rsEccCodewords < rsTempData.length) {
                    rsTempNew = new byte[rsTempData.length - 1];
                    System.arraycopy(rsTempData, 1, rsTempNew, 0, rsTempData.length - 1);
                    rsTempData = (byte[])rsTempNew.clone();
                    continue;
                }
                rsTempNew = new byte[rsEccCodewords];
                System.arraycopy(rsTempData, 1, rsTempNew, 0, rsTempData.length - 1);
                rsTempNew[rsEccCodewords - 1] = 0;
                rsTempData = (byte[])rsTempNew.clone();
            }
            System.arraycopy(rsTempData, 0, res, codewords.length + rsBlockNumber * rsEccCodewords, rsEccCodewords);
        }
        return res;
    }

    private static byte[] calculateByteArrayBits(byte[] xa, byte[] xb, String ind) {
        byte[] xs;
        byte[] xl;
        if (xa.length > xb.length) {
            xl = (byte[])xa.clone();
            xs = (byte[])xb.clone();
        } else {
            xl = (byte[])xb.clone();
            xs = (byte[])xa.clone();
        }
        int ll = xl.length;
        int ls = xs.length;
        byte[] res = new byte[ll];
        for (int i = 0; i < ll; ++i) {
            if (i < ls) {
                if (ind == "xor") {
                    res[i] = (byte)(xl[i] ^ xs[i]);
                    continue;
                }
                res[i] = (byte)(xl[i] | xs[i]);
                continue;
            }
            res[i] = xl[i];
        }
        return res;
    }

    private static byte selectMask(byte[][] matrixContent, int maxCodewordsBitWithRemain) {
        int l = matrixContent.length;
        int[] d1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        int[] d2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        int[] d3 = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        int[] d4 = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        int d2And = 0;
        int d2Or = 0;
        int[] d4Counter = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
        for (int y = 0; y < l; ++y) {
            int[] xData = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
            int[] yData = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
            boolean[] xD1Flag = new boolean[]{false, false, false, false, false, false, false, false};
            boolean[] yD1Flag = new boolean[]{false, false, false, false, false, false, false, false};
            for (int x = 0; x < l; ++x) {
                if (x > 0 && y > 0) {
                    d2And = matrixContent[x][y] & matrixContent[x - 1][y] & matrixContent[x][y - 1] & matrixContent[x - 1][y - 1] & 0xFF;
                    d2Or = matrixContent[x][y] & 0xFF | matrixContent[x - 1][y] & 0xFF | matrixContent[x][y - 1] & 0xFF | matrixContent[x - 1][y - 1] & 0xFF;
                }
                for (int maskNumber = 0; maskNumber < 8; ++maskNumber) {
                    xData[maskNumber] = (xData[maskNumber] & 0x3F) << 1 | (matrixContent[x][y] & 0xFF) >>> maskNumber & 1;
                    yData[maskNumber] = (yData[maskNumber] & 0x3F) << 1 | (matrixContent[y][x] & 0xFF) >>> maskNumber & 1;
                    if ((matrixContent[x][y] & 1 << maskNumber) != 0) {
                        int n = maskNumber;
                        d4Counter[n] = d4Counter[n] + 1;
                    }
                    if (xData[maskNumber] == 93) {
                        int n = maskNumber;
                        d3[n] = d3[n] + 40;
                    }
                    if (yData[maskNumber] == 93) {
                        int n = maskNumber;
                        d3[n] = d3[n] + 40;
                    }
                    if (x > 0 && y > 0) {
                        if ((d2And & 1) != 0 || (d2Or & 1) == 0) {
                            int n = maskNumber;
                            d2[n] = d2[n] + 3;
                        }
                        d2And >>= 1;
                        d2Or >>= 1;
                    }
                    if ((xData[maskNumber] & 0x1F) == 0 || (xData[maskNumber] & 0x1F) == 31) {
                        if (x > 3) {
                            if (xD1Flag[maskNumber]) {
                                int n = maskNumber;
                                d1[n] = d1[n] + 1;
                            } else {
                                int n = maskNumber;
                                d1[n] = d1[n] + 3;
                                xD1Flag[maskNumber] = true;
                            }
                        }
                    } else {
                        xD1Flag[maskNumber] = false;
                    }
                    if ((yData[maskNumber] & 0x1F) == 0 || (yData[maskNumber] & 0x1F) == 31) {
                        if (x <= 3) continue;
                        if (yD1Flag[maskNumber]) {
                            int n = maskNumber;
                            d1[n] = d1[n] + 1;
                            continue;
                        }
                        int n = maskNumber;
                        d1[n] = d1[n] + 3;
                        yD1Flag[maskNumber] = true;
                        continue;
                    }
                    yD1Flag[maskNumber] = false;
                }
            }
        }
        int minValue = 0;
        byte res = 0;
        int[] d4Value = new int[]{90, 80, 70, 60, 50, 40, 30, 20, 10, 0, 0, 10, 20, 30, 40, 50, 60, 70, 80, 90, 90};
        for (int maskNumber = 0; maskNumber < 8; ++maskNumber) {
            d4[maskNumber] = d4Value[20 * d4Counter[maskNumber] / maxCodewordsBitWithRemain];
            int demerit = d1[maskNumber] + d2[maskNumber] + d3[maskNumber] + d4[maskNumber];
            if (demerit >= minValue && maskNumber != 0) continue;
            res = (byte)maskNumber;
            minValue = demerit;
        }
        return res;
    }

    public char getQrcodeErrorCorrect() {
        return this.qrcodeErrorCorrect;
    }

    public void setQrcodeErrorCorrect(char ecc) {
        this.qrcodeErrorCorrect = ecc;
    }

    public int getQrcodeVersion() {
        return this.qrcodeVersion;
    }

    public void setQrcodeVersion(int version) {
        if (version >= 0 && version <= 40) {
            this.qrcodeVersion = version;
        }
    }

    public char getQrcodeEncodeMode() {
        return this.qrcodeEncodeMode;
    }

    public void setQrcodeEncodeMode(char encMode) {
        this.qrcodeEncodeMode = encMode;
    }

    public void setStructureappend(int m, int n, int p) {
        if (n > 1 && n <= 16 && m > 0 && m <= 16 && p >= 0 && p <= 255) {
            this.qrcodeStructureappendM = m;
            this.qrcodeStructureappendN = n;
            this.qrcodeStructureappendParity = p;
        }
    }

    public int calStructureappendParity(byte[] originaldata) {
        int structureappendParity = 0;
        int originaldataLength = originaldata.length;
        if (originaldataLength > 1) {
            structureappendParity = 0;
            for (int i = 0; i < originaldataLength; ++i) {
                structureappendParity ^= originaldata[i] & 0xFF;
            }
        } else {
            structureappendParity = -1;
        }
        return structureappendParity;
    }

    public boolean[][] calQrcode(byte[] qrcodeData) {
        int i;
        int ec;
        int codewordNumCounterValue;
        int[] codewordNumPlus;
        int dataCounter = 0;
        int dataLength = qrcodeData.length;
        int[] dataValue = new int[dataLength + 32];
        byte[] dataBits = new byte[dataLength + 32];
        if (dataLength <= 0) {
            boolean[][] ret = new boolean[][]{{false}};
            return ret;
        }
        if (this.qrcodeStructureappendN > 1) {
            dataValue[0] = 3;
            dataBits[0] = 4;
            dataValue[1] = this.qrcodeStructureappendM - 1;
            dataBits[1] = 4;
            dataValue[2] = this.qrcodeStructureappendN - 1;
            dataBits[2] = 4;
            dataValue[3] = this.qrcodeStructureappendParity;
            dataBits[3] = 8;
            dataCounter = 4;
        }
        dataBits[dataCounter] = 4;
        switch (this.qrcodeEncodeMode) {
            case 'A': {
                int i2;
                codewordNumPlus = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
                dataValue[dataCounter] = 2;
                dataValue[++dataCounter] = dataLength;
                dataBits[dataCounter] = 9;
                codewordNumCounterValue = dataCounter++;
                for (i2 = 0; i2 < dataLength; ++i2) {
                    char chr = (char)qrcodeData[i2];
                    byte chrValue = 0;
                    if (chr >= '0' && chr < ':') {
                        chrValue = (byte)(chr - 48);
                    } else if (chr >= 'A' && chr < '[') {
                        chrValue = (byte)(chr - 55);
                    } else {
                        if (chr == ' ') {
                            chrValue = (byte)36;
                        }
                        if (chr == '$') {
                            chrValue = (byte)37;
                        }
                        if (chr == '%') {
                            chrValue = (byte)38;
                        }
                        if (chr == '*') {
                            chrValue = (byte)39;
                        }
                        if (chr == '+') {
                            chrValue = (byte)40;
                        }
                        if (chr == '-') {
                            chrValue = (byte)41;
                        }
                        if (chr == '.') {
                            chrValue = (byte)42;
                        }
                        if (chr == '/') {
                            chrValue = (byte)43;
                        }
                        if (chr == ':') {
                            chrValue = (byte)44;
                        }
                    }
                    if (i2 % 2 == 0) {
                        dataValue[dataCounter] = chrValue;
                        dataBits[dataCounter] = 6;
                        continue;
                    }
                    dataValue[dataCounter] = dataValue[dataCounter] * 45 + chrValue;
                    dataBits[dataCounter] = 11;
                    if (i2 >= dataLength - 1) continue;
                    ++dataCounter;
                }
                ++dataCounter;
                break;
            }
            case 'N': {
                int i2;
                codewordNumPlus = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4};
                dataValue[dataCounter] = 1;
                dataValue[++dataCounter] = dataLength;
                dataBits[dataCounter] = 10;
                codewordNumCounterValue = dataCounter++;
                for (i2 = 0; i2 < dataLength; ++i2) {
                    if (i2 % 3 == 0) {
                        dataValue[dataCounter] = qrcodeData[i2] - 48;
                        dataBits[dataCounter] = 4;
                        continue;
                    }
                    dataValue[dataCounter] = dataValue[dataCounter] * 10 + (qrcodeData[i2] - 48);
                    if (i2 % 3 == 1) {
                        dataBits[dataCounter] = 7;
                        continue;
                    }
                    dataBits[dataCounter] = 10;
                    if (i2 >= dataLength - 1) continue;
                    ++dataCounter;
                }
                ++dataCounter;
                break;
            }
            default: {
                int i2;
                codewordNumPlus = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
                dataValue[dataCounter] = 4;
                dataValue[++dataCounter] = dataLength;
                dataBits[dataCounter] = 8;
                codewordNumCounterValue = dataCounter++;
                for (i2 = 0; i2 < dataLength; ++i2) {
                    dataValue[i2 + dataCounter] = qrcodeData[i2] & 0xFF;
                    dataBits[i2 + dataCounter] = 8;
                }
                dataCounter += dataLength;
            }
        }
        int totalDataBits = 0;
        for (int i3 = 0; i3 < dataCounter; ++i3) {
            totalDataBits += dataBits[i3];
        }
        switch (this.qrcodeErrorCorrect) {
            case 'L': {
                ec = 1;
                break;
            }
            case 'Q': {
                ec = 3;
                break;
            }
            case 'H': {
                ec = 2;
                break;
            }
            default: {
                ec = 0;
            }
        }
        int[][] maxDataBitsArray = new int[][]{{0, 128, 224, 352, 512, 688, 864, 992, 1232, 1456, 1728, 2032, 2320, 2672, 2920, 3320, 3624, 4056, 4504, 5016, 5352, 5712, 6256, 6880, 7312, 8000, 8496, 9024, 9544, 10136, 10984, 11640, 12328, 13048, 13800, 14496, 15312, 15936, 16816, 17728, 18672}, {0, 152, 272, 440, 640, 864, 1088, 1248, 1552, 1856, 2192, 2592, 2960, 3424, 3688, 4184, 4712, 5176, 5768, 6360, 6888, 7456, 8048, 8752, 9392, 10208, 10960, 11744, 12248, 13048, 13880, 14744, 15640, 16568, 17528, 18448, 19472, 20528, 21616, 22496, 23648}, {0, 72, 128, 208, 288, 368, 480, 528, 688, 800, 976, 1120, 1264, 1440, 1576, 1784, 2024, 2264, 2504, 2728, 3080, 3248, 3536, 3712, 4112, 4304, 4768, 5024, 5288, 5608, 5960, 6344, 6760, 7208, 7688, 7888, 8432, 8768, 9136, 9776, 10208}, {0, 104, 176, 272, 384, 496, 608, 704, 880, 1056, 1232, 1440, 1648, 1952, 2088, 2360, 2600, 2936, 3176, 3560, 3880, 4096, 4544, 4912, 5312, 5744, 6032, 6464, 6968, 7288, 7880, 8264, 8920, 9368, 9848, 10288, 10832, 11408, 12016, 12656, 13328}};
        int maxDataBits = 0;
        if (this.qrcodeVersion == 0) {
            this.qrcodeVersion = 1;
            for (int i4 = 1; i4 <= 40; ++i4) {
                if (maxDataBitsArray[ec][i4] >= totalDataBits + codewordNumPlus[this.qrcodeVersion]) {
                    maxDataBits = maxDataBitsArray[ec][i4];
                    break;
                }
                ++this.qrcodeVersion;
            }
        } else {
            maxDataBits = maxDataBitsArray[ec][this.qrcodeVersion];
        }
        totalDataBits += codewordNumPlus[this.qrcodeVersion];
        int n = codewordNumCounterValue;
        dataBits[n] = (byte)(dataBits[n] + codewordNumPlus[this.qrcodeVersion]);
        int[] maxCodewordsArray = new int[]{0, 26, 44, 70, 100, 134, 172, 196, 242, 292, 346, 404, 466, 532, 581, 655, 733, 815, 901, 991, 1085, 1156, 1258, 1364, 1474, 1588, 1706, 1828, 1921, 2051, 2185, 2323, 2465, 2611, 2761, 2876, 3034, 3196, 3362, 3532, 3706};
        int maxCodewords = maxCodewordsArray[this.qrcodeVersion];
        int maxModules1side = 17 + (this.qrcodeVersion << 2);
        int[] matrixRemainBit = new int[]{0, 0, 7, 7, 7, 7, 7, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0};
        int byte_num = matrixRemainBit[this.qrcodeVersion] + (maxCodewords << 3);
        byte[] matrixX = new byte[byte_num];
        byte[] matrixY = new byte[byte_num];
        byte[] maskArray = new byte[byte_num];
        byte[] formatInformationX2 = new byte[15];
        byte[] formatInformationY2 = new byte[15];
        byte[] rsEccCodewords = new byte[1];
        byte[] rsBlockOrderTemp = new byte[128];
        try {
            String filename = "/qrcode-data/qrv" + Integer.toString(this.qrcodeVersion) + "_" + Integer.toString(ec) + ".dat";
            InputStream fis = FileUtil.getResourceInputStream(Qrcode.class, (String)filename);
            BufferedInputStream bis = new BufferedInputStream(fis);
            bis.read(matrixX);
            bis.read(matrixY);
            bis.read(maskArray);
            bis.read(formatInformationX2);
            bis.read(formatInformationY2);
            bis.read(rsEccCodewords);
            bis.read(rsBlockOrderTemp);
            bis.close();
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int rsBlockOrderLength = 1;
        for (int i5 = 1; i5 < 128; i5 = (int)((byte)(i5 + 1))) {
            if (rsBlockOrderTemp[i5] != 0) continue;
            rsBlockOrderLength = i5;
            break;
        }
        byte[] rsBlockOrder = new byte[rsBlockOrderLength];
        System.arraycopy(rsBlockOrderTemp, 0, rsBlockOrder, 0, rsBlockOrderLength);
        byte[] formatInformationX1 = new byte[]{0, 1, 2, 3, 4, 5, 7, 8, 8, 8, 8, 8, 8, 8, 8};
        byte[] formatInformationY1 = new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 7, 5, 4, 3, 2, 1, 0};
        int maxDataCodewords = maxDataBits >> 3;
        int modules1Side = 4 * this.qrcodeVersion + 17;
        int matrixTotalBits = modules1Side * modules1Side;
        byte[] frameData = new byte[matrixTotalBits + modules1Side];
        try {
            String filename = "/qrcode-data/qrvfr" + Integer.toString(this.qrcodeVersion) + ".dat";
            InputStream fis = FileUtil.getResourceInputStream(Qrcode.class, (String)filename);
            BufferedInputStream bis = new BufferedInputStream(fis);
            bis.read(frameData);
            bis.close();
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (totalDataBits <= maxDataBits - 4) {
            dataValue[dataCounter] = 0;
            dataBits[dataCounter] = 4;
        } else if (totalDataBits < maxDataBits) {
            dataValue[dataCounter] = 0;
            dataBits[dataCounter] = (byte)(maxDataBits - totalDataBits);
        } else if (totalDataBits > maxDataBits) {
            System.out.println("overflow");
        }
        byte[] dataCodewords = Qrcode.divideDataBy8Bits(dataValue, dataBits, maxDataCodewords);
        byte[] codewords = Qrcode.calculateRSECC(dataCodewords, rsEccCodewords[0], rsBlockOrder, maxDataCodewords, maxCodewords);
        byte[][] matrixContent = new byte[modules1Side][modules1Side];
        for (i = 0; i < modules1Side; ++i) {
            for (int j = 0; j < modules1Side; ++j) {
                matrixContent[j][i] = 0;
            }
        }
        for (i = 0; i < maxCodewords; ++i) {
            byte codeword_i = codewords[i];
            for (int j = 7; j >= 0; --j) {
                int codewordBitsNumber = i * 8 + j;
                matrixContent[matrixX[codewordBitsNumber] & 0xFF][matrixY[codewordBitsNumber] & 0xFF] = (byte)(255 * (codeword_i & 1) ^ maskArray[codewordBitsNumber]);
                codeword_i = (byte)((codeword_i & 0xFF) >>> 1);
            }
        }
        for (int matrixRemain = matrixRemainBit[this.qrcodeVersion]; matrixRemain > 0; --matrixRemain) {
            int remainBitTemp = matrixRemain + maxCodewords * 8 - 1;
            matrixContent[matrixX[remainBitTemp] & 0xFF][matrixY[remainBitTemp] & 0xFF] = (byte)(0xFF ^ maskArray[remainBitTemp]);
        }
        byte maskNumber = Qrcode.selectMask(matrixContent, matrixRemainBit[this.qrcodeVersion] + maxCodewords * 8);
        byte maskContent = (byte)(1 << maskNumber);
        byte formatInformationValue = (byte)(ec << 3 | maskNumber);
        String[] formatInformationArray = new String[]{"101010000010010", "101000100100101", "101111001111100", "101101101001011", "100010111111001", "100000011001110", "100111110010111", "100101010100000", "111011111000100", "111001011110011", "111110110101010", "111100010011101", "110011000101111", "110001100011000", "110110001000001", "110100101110110", "001011010001001", "001001110111110", "001110011100111", "001100111010000", "000011101100010", "000001001010101", "000110100001100", "000100000111011", "011010101011111", "011000001101000", "011111100110001", "011101000000110", "010010010110100", "010000110000011", "010111011011010", "010101111101101"};
        for (int i6 = 0; i6 < 15; ++i6) {
            byte content = Byte.parseByte(formatInformationArray[formatInformationValue].substring(i6, i6 + 1));
            matrixContent[formatInformationX1[i6] & 0xFF][formatInformationY1[i6] & 0xFF] = (byte)(content * 255);
            matrixContent[formatInformationX2[i6] & 0xFF][formatInformationY2[i6] & 0xFF] = (byte)(content * 255);
        }
        boolean[][] out = new boolean[modules1Side][modules1Side];
        int c = 0;
        for (int i7 = 0; i7 < modules1Side; ++i7) {
            for (int j = 0; j < modules1Side; ++j) {
                out[j][i7] = (matrixContent[j][i7] & maskContent) != 0 || frameData[c] == 49;
                ++c;
            }
            ++c;
        }
        return out;
    }
}

