/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.media.code.qrcode.decoder.pattern;

import cn.t.util.media.code.qrcode.decoder.QRCodeDecoder;
import cn.t.util.media.code.qrcode.decoder.exception.AlignmentPatternNotFoundException;
import cn.t.util.media.code.qrcode.decoder.exception.InvalidVersionException;
import cn.t.util.media.code.qrcode.decoder.geom.Axis;
import cn.t.util.media.code.qrcode.decoder.geom.Line;
import cn.t.util.media.code.qrcode.decoder.geom.Point;
import cn.t.util.media.code.qrcode.decoder.pattern.FinderPattern;
import cn.t.util.media.code.qrcode.decoder.pattern.LogicalSeed;
import cn.t.util.media.code.qrcode.decoder.util.DebugCanvas;

public class AlignmentPattern {
    static final int RIGHT = 1;
    static final int BOTTOM = 2;
    static final int LEFT = 3;
    static final int TOP = 4;
    static DebugCanvas canvas = QRCodeDecoder.getCanvas();
    Point[][] center;
    int patternDistance;

    AlignmentPattern(Point[][] center, int patternDistance) {
        this.center = center;
        this.patternDistance = patternDistance;
    }

    public static AlignmentPattern findAlignmentPattern(boolean[][] image, FinderPattern finderPattern) throws AlignmentPatternNotFoundException, InvalidVersionException {
        Point[][] logicalCenters = AlignmentPattern.getLogicalCenter(finderPattern);
        int logicalDistance = logicalCenters[1][0].getX() - logicalCenters[0][0].getX();
        Point[][] centers = null;
        centers = AlignmentPattern.getCenter(image, finderPattern, logicalCenters);
        return new AlignmentPattern(centers, logicalDistance);
    }

    static Point[][] getCenter(boolean[][] image, FinderPattern finderPattern, Point[][] logicalCenters) throws AlignmentPatternNotFoundException {
        int moduleSize = finderPattern.getModuleSize();
        Axis axis = new Axis(finderPattern.getAngle(), moduleSize);
        int sqrtCenters = logicalCenters.length;
        Point[][] centers = new Point[sqrtCenters][sqrtCenters];
        axis.setOrigin(finderPattern.getCenter(0));
        centers[0][0] = axis.translate(3, 3);
        canvas.drawCross(centers[0][0], 0x8888FF);
        axis.setOrigin(finderPattern.getCenter(1));
        centers[sqrtCenters - 1][0] = axis.translate(-3, 3);
        canvas.drawCross(centers[sqrtCenters - 1][0], 0x8888FF);
        axis.setOrigin(finderPattern.getCenter(2));
        centers[0][sqrtCenters - 1] = axis.translate(3, -3);
        canvas.drawCross(centers[0][sqrtCenters - 1], 0x8888FF);
        Point tmpPoint = centers[0][0];
        for (int y = 0; y < sqrtCenters; ++y) {
            for (int x = 0; x < sqrtCenters; ++x) {
                if (x == 0 && y == 0 || x == 0 && y == sqrtCenters - 1 || x == sqrtCenters - 1 && y == 0) continue;
                Point target = null;
                if (y == 0) {
                    if (x > 0 && x < sqrtCenters - 1) {
                        target = axis.translate(centers[x - 1][y], logicalCenters[x][y].getX() - logicalCenters[x - 1][y].getX(), 0);
                        centers[x][y] = new Point(target.getX(), target.getY());
                        canvas.drawCross(centers[x][y], 0xFF88888);
                    }
                } else if (x == 0) {
                    if (y > 0 && y < sqrtCenters - 1) {
                        target = axis.translate(centers[x][y - 1], 0, logicalCenters[x][y].getY() - logicalCenters[x][y - 1].getY());
                        centers[x][y] = new Point(target.getX(), target.getY());
                        canvas.drawCross(centers[x][y], 0xFF88888);
                    }
                } else {
                    Point t1 = axis.translate(centers[x - 1][y], logicalCenters[x][y].getX() - logicalCenters[x - 1][y].getX(), 0);
                    Point t2 = axis.translate(centers[x][y - 1], 0, logicalCenters[x][y].getY() - logicalCenters[x][y - 1].getY());
                    centers[x][y] = new Point((t1.getX() + t2.getX()) / 2, (t1.getY() + t2.getY()) / 2 + 1);
                }
                if (finderPattern.getVersion() > 1) {
                    Point precisionCenter = AlignmentPattern.getPrecisionCenter(image, centers[x][y]);
                    canvas.drawCross(centers[x][y], 0xFF88888);
                    int dx = precisionCenter.getX() - centers[x][y].getX();
                    int dy = precisionCenter.getY() - centers[x][y].getY();
                    canvas.println("Adjust AP(" + x + "," + y + ") to d(" + dx + "," + dy + ")");
                    centers[x][y] = precisionCenter;
                }
                canvas.drawCross(centers[x][y], 0x8888FF);
                canvas.drawLine(new Line(tmpPoint, centers[x][y]), 0xBBBBFF);
                tmpPoint = centers[x][y];
            }
        }
        return centers;
    }

    static Point getPrecisionCenter(boolean[][] image, Point targetPoint) throws AlignmentPatternNotFoundException {
        int lx;
        int dy;
        int rx;
        int tx = targetPoint.getX();
        int ty = targetPoint.getY();
        if (tx < 0 || ty < 0 || tx > image.length - 1 || ty > image[0].length - 1) {
            throw new AlignmentPatternNotFoundException("Alignment Pattern finder exceeded out of image");
        }
        if (!image[targetPoint.getX()][targetPoint.getY()]) {
            int scope = 0;
            boolean found = false;
            while (!found) {
                for (int dy2 = ++scope; dy2 > -scope; --dy2) {
                    for (int dx = scope; dx > -scope; --dx) {
                        int x = targetPoint.getX() + dx;
                        int y = targetPoint.getY() + dy2;
                        if (x < 0 || y < 0 || x > image.length - 1 || y > image[0].length - 1) {
                            throw new AlignmentPatternNotFoundException("Alignment Pattern finder exceeded out of image");
                        }
                        if (!image[x][y]) continue;
                        targetPoint = new Point(targetPoint.getX() + dx, targetPoint.getY() + dy2);
                        canvas.drawPoint(targetPoint, 0xFF88888);
                        found = true;
                    }
                }
            }
        }
        int x = rx;
        int uy = dy = targetPoint.getY();
        int y = dy;
        for (lx = rx = targetPoint.getX(); lx >= 1 && !AlignmentPattern.targetPointOnTheCorner(image, lx, y, lx - 1, y); --lx) {
        }
        while (rx < image.length - 1 && !AlignmentPattern.targetPointOnTheCorner(image, rx, y, rx + 1, y)) {
            ++rx;
        }
        while (uy >= 1 && !AlignmentPattern.targetPointOnTheCorner(image, x, uy, x, uy - 1)) {
            --uy;
        }
        while (dy < image[0].length - 1 && !AlignmentPattern.targetPointOnTheCorner(image, x, dy, x, dy + 1)) {
            ++dy;
        }
        return new Point((lx + rx + 1) / 2, (uy + dy + 1) / 2);
    }

    static boolean targetPointOnTheCorner(boolean[][] image, int x, int y, int nx, int ny) {
        if (x < 0 || y < 0 || nx < 0 || ny < 0 || x > image.length || y > image[0].length || nx > image.length || ny > image[0].length) {
            throw new AlignmentPatternNotFoundException("Alignment Pattern Finder exceeded image edge");
        }
        return !image[x][y] && image[nx][ny];
    }

    public static Point[][] getLogicalCenter(FinderPattern finderPattern) {
        int version = finderPattern.getVersion();
        Point[][] logicalCenters = new Point[1][1];
        int[] logicalSeeds = new int[1];
        logicalSeeds = LogicalSeed.getSeed(version);
        logicalCenters = new Point[logicalSeeds.length][logicalSeeds.length];
        for (int col = 0; col < logicalCenters.length; ++col) {
            for (int row = 0; row < logicalCenters.length; ++row) {
                logicalCenters[row][col] = new Point(logicalSeeds[row], logicalSeeds[col]);
            }
        }
        return logicalCenters;
    }

    public Point[][] getCenter() {
        return this.center;
    }

    public void setCenter(Point[][] center) {
        this.center = center;
    }

    public int getLogicalDistance() {
        return this.patternDistance;
    }
}

