/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.media.code;

import cn.t.util.media.code.qrcode.decoder.DefaultQRCodeImage;
import cn.t.util.media.code.qrcode.decoder.QRCodeDecoder;
import cn.t.util.media.code.qrcode.encoder.QrCodeTwoDimensionCodeConfig;
import cn.t.util.media.code.qrcode.encoder.Qrcode;
import cn.t.util.media.code.zxing.BufferedImageLuminanceSource;
import cn.t.util.media.code.zxing.MatrixToImageWriter;
import cn.t.util.media.code.zxing.ZxingTwoDimensionCodeConfig;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwoDimensionCodeUtil {
    private static final Logger logger = LoggerFactory.getLogger(TwoDimensionCodeUtil.class);

    public static void zxingWriteCode(ZxingTwoDimensionCodeConfig codeConfig, String content, String path) {
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.CHARACTER_SET, codeConfig.getCharset());
        hints.put(EncodeHintType.ERROR_CORRECTION, codeConfig.getErrorCorrectionLevel());
        hints.put(EncodeHintType.MARGIN, codeConfig.getMargin());
        try {
            BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, codeConfig.getWidth(), codeConfig.getHeight(), hints);
            Path file = new File(path).toPath();
            MatrixToImageWriter.writeToPath(bitMatrix, codeConfig.getFormat(), file);
        }
        catch (Exception e) {
            logger.error("\u4e8c\u7ef4\u7801\u8f93\u51fa\u5f02\u5e38", (Throwable)e);
        }
    }

    public static Result zxingReadCode(ZxingTwoDimensionCodeConfig codeConfig, String path) {
        try {
            MultiFormatReader formatReader = new MultiFormatReader();
            File file = new File(path);
            BufferedImage image = ImageIO.read(file);
            BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)new BufferedImageLuminanceSource(image)));
            HashMap<DecodeHintType, String> hints = new HashMap<DecodeHintType, String>();
            hints.put(DecodeHintType.CHARACTER_SET, codeConfig.getCharset());
            Result result = formatReader.decode(binaryBitmap, hints);
            if (logger.isDebugEnabled()) {
                logger.debug("\u4e8c\u7ef4\u7801\u683c\u5f0f\u7c7b\u578b: {}", (Object)result.getBarcodeFormat());
                logger.debug("\u4e8c\u7ef4\u7801\u6587\u672c\u5185\u5bb9: {}", (Object)result.getText());
            }
            return result;
        }
        catch (NotFoundException | IOException e) {
            logger.error(e.toString());
            return null;
        }
    }

    public static void qrCodeWriteCode(QrCodeTwoDimensionCodeConfig codeConfig, String content, String path) throws IOException {
        Qrcode x = new Qrcode();
        x.setQrcodeErrorCorrect(codeConfig.getErrorCorrectLevel());
        x.setQrcodeEncodeMode(codeConfig.getQrcodeEncodeMode());
        x.setQrcodeVersion(codeConfig.getVersion());
        BufferedImage bufferedImage = new BufferedImage(codeConfig.getWidth(), codeConfig.getHeight(), 1);
        Graphics2D gs = bufferedImage.createGraphics();
        gs.setBackground(codeConfig.getBackgroundColor());
        gs.setColor(codeConfig.getFillColor());
        gs.clearRect(0, 0, codeConfig.getWidth(), codeConfig.getHeight());
        byte[] d = content.getBytes();
        if (d.length > 0 && d.length < 120) {
            boolean[][] s = x.calQrcode(d);
            for (int i = 0; i < s.length; ++i) {
                for (int j = 0; j < s.length; ++j) {
                    if (!s[j][i]) continue;
                    gs.fillRect(j * 3 + codeConfig.getPixOff(), i * 3 + codeConfig.getPixOff(), 3, 3);
                }
            }
        }
        gs.dispose();
        bufferedImage.flush();
        ImageIO.write((RenderedImage)bufferedImage, codeConfig.getFormat(), new File(path));
    }

    public static String qrCodeReadCode(QrCodeTwoDimensionCodeConfig codeConfig, String path) {
        try {
            File file = new File(path);
            BufferedImage bufferedImage = ImageIO.read(file);
            QRCodeDecoder codeDecoder = new QRCodeDecoder();
            byte[] decodeBytes = codeDecoder.decode(new DefaultQRCodeImage(bufferedImage));
            return new String(decodeBytes, codeConfig.getCharset());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

