/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.media.video.mp4.builder;

import cn.t.util.common.digital.ByteSequence;
import cn.t.util.media.video.mp4.builder.BoxBuilder;
import cn.t.util.media.video.mp4.modal.Box;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBoxBuilder
implements BoxBuilder {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBoxBuilder.class);
    protected List<BoxBuilder> boxBuilderList = new ArrayList<BoxBuilder>();
    private String supportType;

    public AbstractBoxBuilder() {
        this.initSupport();
    }

    @Override
    public List<Box> build(byte[] bs) throws IOException {
        ByteSequence byteSequence = new ByteSequence(bs);
        byte[] fourBytes = new byte[4];
        ArrayList<Box> boxList = new ArrayList<Box>();
        block0: while (byteSequence.available() > 0) {
            int start = byteSequence.getIndex();
            long size = byteSequence.readInt();
            if (size < 0L) {
                throw new EOFException("bytes not enough");
            }
            long readLength = byteSequence.read(fourBytes);
            String type = new String(fourBytes);
            if (readLength < 0L) {
                throw new EOFException("bytes not enough");
            }
            if (size == 1L) {
                size = byteSequence.readLong();
            }
            if ("uuid".equals(type)) {
                byte[] userTypeBytes = new byte[16];
                readLength = byteSequence.read(userTypeBytes);
                if (readLength < 16L) {
                    throw new EOFException("bytes not enough");
                }
                type = new String(userTypeBytes);
            }
            for (BoxBuilder builder : this.boxBuilderList) {
                if (!builder.support(type)) continue;
                byte[] content = new byte[(int)size - (byteSequence.getIndex() - start)];
                readLength = byteSequence.read(content);
                if (readLength < (long)content.length) {
                    throw new EOFException("bytes not enough");
                }
                boxList.addAll(builder.build(content));
                continue block0;
            }
            logger.warn("no BoxBuilder found by type: {}", (Object)new String(fourBytes));
            readLength = byteSequence.skip(size - 8L);
            if (readLength >= 0L) continue;
            throw new EOFException("bytes not enough");
        }
        return boxList;
    }

    @Override
    public boolean support(String type) {
        return this.supportType.equals(type);
    }

    @Override
    public List<BoxBuilder> getBoxBuilderList() {
        return this.boxBuilderList;
    }

    protected void addBoxBuilder(BoxBuilder boxBuilder) {
        if (boxBuilder != null) {
            this.boxBuilderList.add(boxBuilder);
        }
    }

    protected void addBoxBuilderList(List<BoxBuilder> boxBuilderList) {
        if (boxBuilderList != null && boxBuilderList.size() > 0) {
            this.boxBuilderList.addAll(boxBuilderList);
        }
    }

    public void initSupport() {
        this.supportType = this.getSupport();
    }

    public abstract String getSupport();
}

