/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.media.code.qrcode.decoder;

import cn.t.util.media.code.qrcode.decoder.data.QRCodeImage;
import cn.t.util.media.code.qrcode.decoder.data.QRCodeSymbol;
import cn.t.util.media.code.qrcode.decoder.exception.DecodingFailedException;
import cn.t.util.media.code.qrcode.decoder.exception.InvalidDataBlockException;
import cn.t.util.media.code.qrcode.decoder.exception.SymbolNotFoundException;
import cn.t.util.media.code.qrcode.decoder.geom.Point;
import cn.t.util.media.code.qrcode.decoder.reader.QRCodeDataBlockReader;
import cn.t.util.media.code.qrcode.decoder.reader.QRCodeImageReader;
import cn.t.util.media.code.qrcode.decoder.reedsolomon.RsDecode;
import cn.t.util.media.code.qrcode.decoder.util.DebugCanvas;
import cn.t.util.media.code.qrcode.decoder.util.DebugCanvasAdapter;
import java.util.Vector;

public class QRCodeDecoder {
    static DebugCanvas canvas;
    int numTryDecode = 0;
    QRCodeSymbol qrCodeSymbol;
    Vector results;
    Vector lastResults = new Vector();
    QRCodeImageReader imageReader;
    int numLastCorrectionFailures;

    public QRCodeDecoder() {
        this.results = new Vector();
        canvas = new DebugCanvasAdapter();
    }

    public static DebugCanvas getCanvas() {
        return canvas;
    }

    public static void setCanvas(DebugCanvas canvas) {
        QRCodeDecoder.canvas = canvas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decode(QRCodeImage qrCodeImage) throws DecodingFailedException {
        Point[] adjusts = this.getAdjustPoints();
        Vector<DecodeResult> results = new Vector<DecodeResult>();
        this.numTryDecode = 0;
        while (this.numTryDecode < adjusts.length) {
            try {
                DecodeResult result = this.decode(qrCodeImage, adjusts[this.numTryDecode]);
                if (result.isCorrectionSucceeded()) {
                    byte[] byArray = result.getDecodedBytes();
                    return byArray;
                }
                results.addElement(result);
                canvas.println("Decoding succeeded but could not correct");
                canvas.println("all errors. Retrying..");
            }
            catch (DecodingFailedException dfe) {
                if (dfe.getMessage().indexOf("Finder Pattern") < 0) continue;
                throw dfe;
            }
            finally {
                ++this.numTryDecode;
            }
        }
        if (results.size() == 0) {
            throw new DecodingFailedException("Give up decoding");
        }
        int minErrorIndex = -1;
        int minError = Integer.MAX_VALUE;
        for (int i = 0; i < results.size(); ++i) {
            DecodeResult result = (DecodeResult)results.elementAt(i);
            if (result.getNumCorrectuionFailures() >= minError) continue;
            minError = result.getNumCorrectuionFailures();
            minErrorIndex = i;
        }
        canvas.println("All trials need for correct error");
        canvas.println("Reporting #" + minErrorIndex + " that,");
        canvas.println("corrected minimum errors (" + minError + ")");
        canvas.println("Decoding finished.");
        return ((DecodeResult)results.elementAt(minErrorIndex)).getDecodedBytes();
    }

    Point[] getAdjustPoints() {
        Vector<Point> adjustPoints = new Vector<Point>();
        for (int d = 0; d < 4; ++d) {
            adjustPoints.addElement(new Point(1, 1));
        }
        int lastX = 0;
        int lastY = 0;
        for (int y = 0; y > -4; --y) {
            for (int x = 0; x > -4; --x) {
                if (x == y || (x + y) % 2 != 0) continue;
                adjustPoints.addElement(new Point(x - lastX, y - lastY));
                lastX = x;
                lastY = y;
            }
        }
        Point[] adjusts = new Point[adjustPoints.size()];
        for (int i = 0; i < adjusts.length; ++i) {
            adjusts[i] = (Point)adjustPoints.elementAt(i);
        }
        return adjusts;
    }

    DecodeResult decode(QRCodeImage qrCodeImage, Point adjust) throws DecodingFailedException {
        try {
            if (this.numTryDecode == 0) {
                canvas.println("Decoding started");
                int[][] intImage = this.imageToIntArray(qrCodeImage);
                this.imageReader = new QRCodeImageReader();
                this.qrCodeSymbol = this.imageReader.getQRCodeSymbol(intImage);
            } else {
                canvas.println("--");
                canvas.println("Decoding restarted #" + this.numTryDecode);
                this.qrCodeSymbol = this.imageReader.getQRCodeSymbolWithAdjustedGrid(adjust);
            }
        }
        catch (SymbolNotFoundException e) {
            throw new DecodingFailedException(e.getMessage());
        }
        canvas.println("Created QRCode symbol.");
        canvas.println("Reading symbol.");
        canvas.println("Version: " + this.qrCodeSymbol.getVersionReference());
        canvas.println("Mask pattern: " + this.qrCodeSymbol.getMaskPatternRefererAsString());
        int[] blocks = this.qrCodeSymbol.getBlocks();
        canvas.println("Correcting data errors.");
        blocks = this.correctDataBlocks(blocks);
        try {
            byte[] decodedByteArray = this.getDecodedByteArray(blocks, this.qrCodeSymbol.getVersion(), this.qrCodeSymbol.getNumErrorCollectionCode());
            return new DecodeResult(decodedByteArray, this.numLastCorrectionFailures);
        }
        catch (InvalidDataBlockException e) {
            canvas.println(e.getMessage());
            throw new DecodingFailedException(e.getMessage());
        }
    }

    int[][] imageToIntArray(QRCodeImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[][] intImage = new int[width][height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                intImage[x][y] = image.getPixel(x, y);
            }
        }
        return intImage;
    }

    int[] correctDataBlocks(int[] blocks) {
        int numSucceededCorrections = 0;
        int numCorrectionFailures = 0;
        int dataCapacity = this.qrCodeSymbol.getDataCapacity();
        int[] dataBlocks = new int[dataCapacity];
        int numErrorCollectionCode = this.qrCodeSymbol.getNumErrorCollectionCode();
        int numRSBlocks = this.qrCodeSymbol.getNumRSBlocks();
        int eccPerRSBlock = numErrorCollectionCode / numRSBlocks;
        if (numRSBlocks == 1) {
            RsDecode corrector = new RsDecode(eccPerRSBlock / 2);
            int ret = corrector.decode(blocks);
            if (ret > 0) {
                numSucceededCorrections += ret;
            } else if (ret < 0) {
                ++numCorrectionFailures;
            }
            return blocks;
        }
        int numLongerRSBlocks = dataCapacity % numRSBlocks;
        if (numLongerRSBlocks == 0) {
            int lengthRSBlock = dataCapacity / numRSBlocks;
            int[][] RSBlocks = new int[numRSBlocks][lengthRSBlock];
            for (int i = 0; i < numRSBlocks; ++i) {
                for (int j = 0; j < lengthRSBlock; ++j) {
                    RSBlocks[i][j] = blocks[j * numRSBlocks + i];
                }
                canvas.println("eccPerRSBlock=" + eccPerRSBlock);
                RsDecode corrector = new RsDecode(eccPerRSBlock / 2);
                int ret = corrector.decode(RSBlocks[i]);
                if (ret > 0) {
                    numSucceededCorrections += ret;
                    continue;
                }
                if (ret >= 0) continue;
                ++numCorrectionFailures;
            }
            int p = 0;
            for (int i = 0; i < numRSBlocks; ++i) {
                for (int j = 0; j < lengthRSBlock - eccPerRSBlock; ++j) {
                    dataBlocks[p++] = RSBlocks[i][j];
                }
            }
        } else {
            int lengthShorterRSBlock = dataCapacity / numRSBlocks;
            int lengthLongerRSBlock = dataCapacity / numRSBlocks + 1;
            int numShorterRSBlocks = numRSBlocks - numLongerRSBlocks;
            int[][] shorterRSBlocks = new int[numShorterRSBlocks][lengthShorterRSBlock];
            int[][] longerRSBlocks = new int[numLongerRSBlocks][lengthLongerRSBlock];
            for (int i = 0; i < numRSBlocks; ++i) {
                int ret;
                RsDecode corrector;
                int mod;
                if (i < numShorterRSBlocks) {
                    mod = 0;
                    for (int j = 0; j < lengthShorterRSBlock; ++j) {
                        if (j == lengthShorterRSBlock - eccPerRSBlock) {
                            mod = numLongerRSBlocks;
                        }
                        shorterRSBlocks[i][j] = blocks[j * numRSBlocks + i + mod];
                    }
                    canvas.println("eccPerRSBlock(shorter)=" + eccPerRSBlock);
                    corrector = new RsDecode(eccPerRSBlock / 2);
                    ret = corrector.decode(shorterRSBlocks[i]);
                    if (ret > 0) {
                        numSucceededCorrections += ret;
                        continue;
                    }
                    if (ret >= 0) continue;
                    ++numCorrectionFailures;
                    continue;
                }
                mod = 0;
                for (int j = 0; j < lengthLongerRSBlock; ++j) {
                    if (j == lengthShorterRSBlock - eccPerRSBlock) {
                        mod = numShorterRSBlocks;
                    }
                    longerRSBlocks[i - numShorterRSBlocks][j] = blocks[j * numRSBlocks + i - mod];
                }
                canvas.println("eccPerRSBlock(longer)=" + eccPerRSBlock);
                corrector = new RsDecode(eccPerRSBlock / 2);
                ret = corrector.decode(longerRSBlocks[i - numShorterRSBlocks]);
                if (ret > 0) {
                    numSucceededCorrections += ret;
                    continue;
                }
                if (ret >= 0) continue;
                ++numCorrectionFailures;
            }
            int p = 0;
            for (int i = 0; i < numRSBlocks; ++i) {
                int j;
                if (i < numShorterRSBlocks) {
                    for (j = 0; j < lengthShorterRSBlock - eccPerRSBlock; ++j) {
                        dataBlocks[p++] = shorterRSBlocks[i][j];
                    }
                    continue;
                }
                for (j = 0; j < lengthLongerRSBlock - eccPerRSBlock; ++j) {
                    dataBlocks[p++] = longerRSBlocks[i - numShorterRSBlocks][j];
                }
            }
        }
        if (numSucceededCorrections > 0) {
            canvas.println(String.valueOf(numSucceededCorrections) + " data errors corrected successfully.");
        } else {
            canvas.println("No errors found.");
        }
        this.numLastCorrectionFailures = numCorrectionFailures;
        return dataBlocks;
    }

    byte[] getDecodedByteArray(int[] blocks, int version, int numErrorCorrectionCode) throws InvalidDataBlockException {
        QRCodeDataBlockReader reader = new QRCodeDataBlockReader(blocks, version, numErrorCorrectionCode);
        byte[] byteArray = reader.getDataByte();
        return byteArray;
    }

    class DecodeResult {
        int numCorrectionFailures;
        byte[] decodedBytes;

        public DecodeResult(byte[] decodedBytes, int numCorrectionFailures) {
            this.decodedBytes = decodedBytes;
            this.numCorrectionFailures = numCorrectionFailures;
        }

        public byte[] getDecodedBytes() {
            return this.decodedBytes;
        }

        public int getNumCorrectuionFailures() {
            return this.numCorrectionFailures;
        }

        public boolean isCorrectionSucceeded() {
            return QRCodeDecoder.this.numLastCorrectionFailures == 0;
        }
    }
}

