package cn.t.util.jvm.datatype.reader;

import cn.t.util.jvm.ConstantsPoolDataType;
import cn.t.util.jvm.datatype.StringInfo;
import cn.t.util.jvm.datatype.base.DataType;

import java.io.DataInputStream;
import java.io.IOException;

public class StringInfoReader extends AbstractDataTypeReader {

    @Override
    public DataType read(DataInputStream dataInputStream) throws IOException {
        StringInfo stringInfo = new StringInfo();
        stringInfo.setValueIndex(dataInputStream.readShort());
        return stringInfo;
    }

    public StringInfoReader() {
        super(ConstantsPoolDataType.STRING);
    }
}
