package cn.t.util.jvm.datatype.reader;

import cn.t.util.jvm.ConstantsPoolDataType;
import cn.t.util.jvm.datatype.MethodrefInfo;
import cn.t.util.jvm.datatype.base.DataType;

import java.io.DataInputStream;
import java.io.IOException;

public class MethodrefInfoReader extends AbstractDataTypeReader {

    @Override
    public DataType read(DataInputStream dataInputStream) throws IOException {
        MethodrefInfo methodrefInfo = new MethodrefInfo();
        methodrefInfo.setClassInfoIndex(dataInputStream.readShort());
        methodrefInfo.setNameAndTypeInfoIndex(dataInputStream.readShort());
        return methodrefInfo;
    }

    public MethodrefInfoReader() {
        super(ConstantsPoolDataType.METHODREF);
    }
}
