package cn.t.util.jvm.datatype.reader;

import cn.t.util.jvm.ConstantsPoolDataType;
import cn.t.util.jvm.datatype.ClassInfo;
import cn.t.util.jvm.datatype.base.DataType;

import java.io.DataInputStream;
import java.io.IOException;

public class ClassInfoReader extends AbstractDataTypeReader {

    @Override
    public DataType read(DataInputStream dataInputStream) throws IOException {
        ClassInfo type = new ClassInfo();
        type.setQualifiedNameIndex(dataInputStream.readShort());
        return type;
    }

    public ClassInfoReader() {
        super(ConstantsPoolDataType.CLASS);
    }
}
