package cn.t.util.jvm.datatype;

import cn.t.util.jvm.ConstantsPoolDataType;
import cn.t.util.jvm.datatype.base.DataType;

public class MethodTypeInfo extends DataType {

    private short descriptorIndex;

    public MethodTypeInfo() {
        super(ConstantsPoolDataType.METHODTYPE);
    }

    public MethodTypeInfo(short descriptorIndex) {
        super(ConstantsPoolDataType.METHODTYPE);
        this.descriptorIndex = descriptorIndex;
    }

    public short getDescriptorIndex() {
        return descriptorIndex;
    }

    public void setDescriptorIndex(short descriptorIndex) {
        this.descriptorIndex = descriptorIndex;
    }
}
