package cn.t.util.jvm.datatype.reader;

import cn.t.util.jvm.ConstantsPoolDataType;
import cn.t.util.jvm.datatype.NameAndTypeInfo;
import cn.t.util.jvm.datatype.base.DataType;

import java.io.DataInputStream;
import java.io.IOException;

public class NameAndTypeInfoReader extends AbstractDataTypeReader {

    @Override
    public DataType read(DataInputStream dataInputStream) throws IOException {
        NameAndTypeInfo nameAndTypeInfo = new NameAndTypeInfo();
        nameAndTypeInfo.setNameIndex(dataInputStream.readShort());
        nameAndTypeInfo.setTypeIndex(dataInputStream.readShort());
        return nameAndTypeInfo;
    }

    public NameAndTypeInfoReader() {
        super(ConstantsPoolDataType.NAMEANDTYPE);
    }
}
