package cn.t.util.jvm.datatype.reader;

import cn.t.util.jvm.ConstantsPoolDataType;
import cn.t.util.jvm.datatype.MethodTypeInfo;
import cn.t.util.jvm.datatype.base.DataType;

import java.io.DataInputStream;
import java.io.IOException;

public class MethodTypeInfoReader extends AbstractDataTypeReader {

    @Override
    public DataType read(DataInputStream dataInputStream) throws IOException {
        MethodTypeInfo methodTypeInfo = new MethodTypeInfo();
        methodTypeInfo.setDescriptorIndex(dataInputStream.readShort());
        return methodTypeInfo;
    }

    public MethodTypeInfoReader() {
        super(ConstantsPoolDataType.METHODTYPE);
    }
}
