package cn.t.util.jvm.datatype.reader;

import cn.t.util.jvm.ConstantsPoolDataType;
import cn.t.util.jvm.datatype.MethodHandleInfo;
import cn.t.util.jvm.datatype.base.DataType;

import java.io.DataInputStream;
import java.io.IOException;

public class MethodHandleInfoReader extends AbstractDataTypeReader {

    @Override
    public DataType read(DataInputStream dataInputStream) throws IOException {
        MethodHandleInfo methodHandleInfo = new MethodHandleInfo();
        methodHandleInfo.setReferenceKind(dataInputStream.readByte());
        methodHandleInfo.setReferenceIndex(dataInputStream.readShort());
        return methodHandleInfo;
    }

    public MethodHandleInfoReader() {
        super(ConstantsPoolDataType.METHODHANDLE);
    }
}
