package cn.t.util.jvm.datatype.reader;

import cn.t.util.jvm.ConstantsPoolDataType;
import cn.t.util.jvm.datatype.InvokeDynamicInfo;
import cn.t.util.jvm.datatype.base.DataType;

import java.io.DataInputStream;
import java.io.IOException;

public class InvokeDynamicInfoReader extends AbstractDataTypeReader {

    @Override
    public DataType read(DataInputStream dataInputStream) throws IOException {
        InvokeDynamicInfo invokeDynamicInfo = new InvokeDynamicInfo();
        invokeDynamicInfo.setBootstrapMethodAttrIndex(dataInputStream.readShort());
        invokeDynamicInfo.setNameAndTypeIndex(dataInputStream.readShort());
        return invokeDynamicInfo;
    }

    public InvokeDynamicInfoReader() {
        super(ConstantsPoolDataType.INVOKEDYNAMIC);
    }
}
