package cn.t.util.jvm.datatype.reader;

import cn.t.util.jvm.ConstantsPoolDataType;
import cn.t.util.jvm.datatype.InterfaceMethodrefInfo;
import cn.t.util.jvm.datatype.base.DataType;

import java.io.DataInputStream;
import java.io.IOException;

public class InterfaceMethodrefInfoReader extends AbstractDataTypeReader {

    @Override
    public DataType read(DataInputStream dataInputStream) throws IOException {
        InterfaceMethodrefInfo interfaceMethodrefInfo = new InterfaceMethodrefInfo();
        interfaceMethodrefInfo.setClassInfoIndex(dataInputStream.readShort());
        interfaceMethodrefInfo.setNameAndTypeInfoIndex(dataInputStream.readShort());
        return interfaceMethodrefInfo;
    }

    public InterfaceMethodrefInfoReader() {
        super(ConstantsPoolDataType.INTERFACEMETHODREF);
    }
}
