package cn.t.util.jvm.datatype.reader;

import cn.t.util.jvm.ConstantsPoolDataType;
import cn.t.util.jvm.datatype.FieldrefInfo;
import cn.t.util.jvm.datatype.base.DataType;

import java.io.DataInputStream;
import java.io.IOException;

public class FieldrefInfoReader extends AbstractDataTypeReader {

    @Override
    public DataType read(DataInputStream dataInputStream) throws IOException {
        FieldrefInfo fieldrefInfo = new FieldrefInfo();
        fieldrefInfo.setClassInfoIndex(dataInputStream.readShort());
        fieldrefInfo.setNameAndTypeInfoIndex(dataInputStream.readShort());
        return fieldrefInfo;
    }

    public FieldrefInfoReader() {
        super(ConstantsPoolDataType.FIELDREF);
    }
}
