package cn.t.util.jvm;

public enum AttributeType {

    ConstantValue("ConstantValue"),
    Code("Code"),
    StackMapTable("StackMapTable"),
    Exceptions("Exceptions"),
    InnerClasses("InnerClasses"),
    EnclosingMethod("EnclosingMethod"),
    Synthetic("Synthetic"),
    Signature("Signature"),
    SourceFile("SourceFile"),
    SourceDebugExtension("SourceDebugExtension"),
    LineNumberTable("LineNumberTable"),
    LocalVariableTable("LocalVariableTable"),
    LocalVariableTypeTable("LocalVariableTypeTable"),
    Deprecated("Deprecated"),
    RuntimeVisibleAnnotations("RuntimeVisibleAnnotations"),
    RuntimeInvisibleAnnotations("RuntimeInvisibleAnnotations"),
    RuntimeVisibleParameterAnnotations("RuntimeVisibleParameterAnnotations"),
    RuntimeInvisibleParameterAnnotations("RuntimeInvisibleParameterAnnotations"),
    AnnotationDefault("AnnotationDefault"),
    BootstrapMethods("BootstrapMethods")
    ;

    public static AttributeType getAttributeType(String value) {
        for(AttributeType type: values()) {
            if(type.value.equalsIgnoreCase(value)) {
                return type;
            }
        }
        return null;
    }

    public String value;

    AttributeType(String value) {
        this.value = value;
    }
}
