/*
 * Decompiled with CFR 0.152.
 */
package cn.t.util.io.crypto;

import cn.t.util.io.FileUtil;
import cn.t.util.io.crypto.Context;
import cn.t.util.io.crypto.config.RepositoryConfiguration;
import cn.t.util.io.crypto.config.RuntimeConfiguration;
import cn.t.util.io.crypto.helper.RepositoryHelper;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileEncrypt {
    private static Logger logger = LoggerFactory.getLogger(FileEncrypt.class);
    private RepositoryConfiguration repositoryConfiguration = new RepositoryConfiguration();
    private RuntimeConfiguration runtimeConfiguration = new RuntimeConfiguration();
    private Context context = new Context();
    private RepositoryHelper repositoryHelper;

    public void encrypt(String target, String to, String resourceName) throws IOException {
        File original = new File(target);
        to = this.repositoryHelper.completeRepositoryPath(to);
        File repository = new File(to);
        if (!original.exists()) {
            logger.warn("specified file or directory not exist, ignore encrypt");
            return;
        }
        File indexDirectory = new File(FileUtil.appendFilePath(repository.getAbsolutePath(), this.context.getRepositoryConfiguration().getIndexDirectoryName()));
        File dataDirectory = new File(FileUtil.appendFilePath(repository.getAbsolutePath(), this.context.getRepositoryConfiguration().getDataDirectoryName()));
        this.context.getRuntimeConfiguration().setUserResource(original);
        this.context.getRuntimeConfiguration().setRepositoryDirectory(repository);
        this.context.getRuntimeConfiguration().setIndexDirectory(indexDirectory);
        this.context.getRuntimeConfiguration().setDataDirectory(dataDirectory);
        this.repositoryHelper.initRepository();
        this.repositoryHelper.persistData(resourceName, original);
    }

    public FileEncrypt() {
        this.context.setRepositoryConfiguration(this.repositoryConfiguration);
        this.context.setRuntimeConfiguration(this.runtimeConfiguration);
        this.repositoryHelper = new RepositoryHelper(this.context);
    }
}

